<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index()
    {
        $blogs = Blog::published()->orderBy('published_at', 'desc')->paginate(10);
        
        // SEO for main blog page
        $seo = [
            'meta_title' => 'Automotive Blog - Ultimate Auto Care',
            'meta_description' => 'Read our latest tips and news about car repair, maintenance, and restored classics.',
        ];

        return view('blogs.index', array_merge($seo, compact('blogs')));
    }

    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)->published()->firstOrFail();

        $seo = [
            'meta_title' => $blog->meta_title ?: $blog->title,
            'meta_description' => $blog->meta_description,
            'canonical_url' => $blog->canonical_url,
            'og_title' => $blog->og_title,
            'og_description' => $blog->og_description,
            'og_image' => $blog->og_image,
            'schema_json' => $blog->schema_json,
            'is_index' => $blog->is_index,
        ];

        return view('blogs.show', array_merge($seo, compact('blog')));
    }
}
