<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Car extends Model
{
    use HasSlug;

    protected $fillable = [
        'make',
        'model',
        'vin',
        'stock_number',
        'year',
        'price',
        'market_avg_price',
        'type',
        'image',
        'description',
        'fuel_type',
        'transmission',
        'mileage',
        'ext_color',
        'int_color',
        'engine',
        'drive_type',
        'is_featured',
        'status',
        'seller_name',
        // SEO Fields
        'meta_title',
        'meta_description',
        'slug',
        'canonical_url',
        'og_title',
        'og_description',
        'og_image',
        'schema_json',
        'is_index',
        'image_alt',
    ];

    protected $casts = [
        'is_featured' => 'boolean',
        'price' => 'decimal:2',
        'market_avg_price' => 'decimal:2',
        'is_index' => 'boolean',
        'schema_json' => 'array',
    ];

    public function getMetaTitleAttribute($value)
    {
        return $value ?: "{$this->year} {$this->make} {$this->model} - Ultimate Auto Care";
    }

    public function getMetaDescriptionAttribute($value)
    {
        return $value ?: Str::limit($this->description, 160);
    }
}
