<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasSlug;

    protected $fillable = [
        'title', 'slug', 'icon', 'description', 'content', 'featured_image', 'image_alt',
        'benefits', 'features', 'price_starting_from',
        'meta_title', 'meta_description', 'canonical_url', 'og_title', 
        'og_description', 'og_image', 'schema_json', 'is_index', 'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_index' => 'boolean',
        'schema_json' => 'array',
        'benefits' => 'array',
        'features' => 'array',
    ];

    public function getMetaTitleAttribute($value)
    {
        return $value ?: $this->title . ' - Professional Car Services';
    }

    public function getMetaDescriptionAttribute($value)
    {
        return $value ?: $this->description;
    }
}
