<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('admin_users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('role')->default('admin'); // admin, super_admin
            $table->boolean('is_active')->default(true);
            $table->timestamp('last_login_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('financing_applications', function (Blueprint $table) {
            $table->id();
            $table->string('application_type')->default('car_sale'); // car_sale, repair
            $table->string('status')->default('pending'); // pending, reviewing, approved, rejected
            // Loan Info
            $table->decimal('desired_loan_amount', 12, 2)->nullable();
            $table->decimal('desired_monthly_payment', 12, 2)->nullable();
            $table->string('selected_vehicle')->nullable();
            $table->decimal('down_payment', 12, 2)->nullable();
            // Personal Info
            $table->string('first_name');
            $table->string('last_name');
            $table->text('address');
            $table->string('landmark')->nullable();
            $table->string('city');
            $table->string('state');
            $table->string('zip_code');
            $table->string('country');
            $table->string('daytime_phone');
            $table->string('evening_phone')->nullable();
            $table->string('fax')->nullable();
            $table->string('email');
            // Residence & Verification
            $table->string('ssn_last4')->nullable(); // Store only last 4 digits for security
            $table->date('date_of_birth')->nullable();
            $table->string('residence_type')->nullable();
            $table->decimal('mortgage_rent_payment', 10, 2)->nullable();
            $table->integer('time_at_residence_years')->nullable();
            $table->text('prior_address')->nullable();
            $table->json('account_types')->nullable(); // ['Utilities', 'Savings', etc.]
            $table->string('drivers_license_number')->nullable();
            $table->string('drivers_license_state')->nullable();
            $table->date('drivers_license_expiry')->nullable();
            // Employment Info
            $table->string('employer_name')->nullable();
            $table->text('employer_address')->nullable();
            $table->string('employer_city')->nullable();
            $table->string('employer_state')->nullable();
            $table->string('employer_zip')->nullable();
            $table->string('employer_country')->nullable();
            $table->string('business_phone')->nullable();
            $table->string('employment_status')->nullable();
            $table->string('occupation')->nullable();
            $table->integer('time_on_job_years')->nullable();
            $table->string('pay_frequency')->nullable();
            $table->decimal('paycheck_amount', 10, 2)->nullable();
            $table->json('other_income_types')->nullable();
            $table->text('other_income_detail')->nullable();
            // Vehicle Info
            $table->string('vehicle_make')->nullable();
            $table->string('vehicle_model')->nullable();
            $table->string('vehicle_year')->nullable();
            $table->string('vehicle_mileage')->nullable();
            // Trade-in
            $table->string('tradein_make')->nullable();
            $table->string('tradein_model')->nullable();
            $table->string('tradein_year')->nullable();
            $table->string('tradein_mileage')->nullable();
            // Additional
            $table->text('additional_comments')->nullable();
            $table->boolean('consent_given')->default(false);
            $table->string('ip_address')->nullable();
            $table->text('admin_notes')->nullable();
            $table->timestamps();
        });

        Schema::create('contact_messages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('phone')->nullable();
            $table->string('subject')->nullable();
            $table->text('message');
            $table->string('status')->default('unread'); // unread, read, replied
            $table->text('admin_reply')->nullable();
            $table->string('ip_address')->nullable();
            $table->timestamps();
        });

        Schema::create('service_bookings', function (Blueprint $table) {
            $table->id();
            $table->string('customer_name');
            $table->string('customer_email');
            $table->string('customer_phone');
            $table->string('vehicle_make')->nullable();
            $table->string('vehicle_model')->nullable();
            $table->string('vehicle_year')->nullable();
            $table->string('service_type');
            $table->date('preferred_date')->nullable();
            $table->string('preferred_time')->nullable();
            $table->text('notes')->nullable();
            $table->string('status')->default('pending'); // pending, confirmed, completed, cancelled
            $table->timestamps();
        });

        Schema::create('newsletter_subscribers', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique();
            $table->string('name')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('newsletter_subscribers');
        Schema::dropIfExists('service_bookings');
        Schema::dropIfExists('contact_messages');
        Schema::dropIfExists('financing_applications');
        Schema::dropIfExists('admin_users');
    }
};
