<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('text'); // text, json, image
            $table->timestamps();
        });

        // Seed basic business info
        DB::table('settings')->insert([
            ['key' => 'business_name', 'value' => 'Ultimate Auto Care', 'type' => 'text'],
            ['key' => 'business_address', 'value' => '123 Luxury Lane, Automotive City, AC 12345', 'type' => 'text'],
            ['key' => 'business_phone', 'value' => '+1 (555) 123-4567', 'type' => 'text'],
            ['key' => 'business_opening_hours', 'value' => 'Mo-Fr 08:00-18:00, Sa 09:00-14:00', 'type' => 'text'],
            ['key' => 'business_email', 'value' => 'info@ultimateautocare.com', 'type' => 'text'],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
