<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\AdminUser;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        AdminUser::updateOrCreate(
            ['email' => 'admin@ultimateautocare.com'],
            [
                'name'      => 'Super Admin',
                'password'  => Hash::make('Admin@2024!'),
                'role'      => 'super_admin',
                'is_active' => true,
            ]
        );

        $this->command->info('✅ Admin user created!');
        $this->command->info('   Email:    admin@ultimateautocare.com');
        $this->command->info('   Password: Admin@2024!');
    }
}
