<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class SeoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'title' => 'Home',
                'slug' => 'home',
                'meta_title' => 'Ultimate Auto Care | Premium Car Repair & Restored Classics',
                'meta_description' => 'Expert car repair services and premium vintage cars for sale. From diagnostics to restoration, Ultimate Auto Care is your trusted automotive partner.',
            ],
            [
                'title' => 'About Us',
                'slug' => 'about',
                'meta_title' => 'About Ultimate Auto Care | Our Story & Expertise',
                'meta_description' => 'Learn more about Ultimate Auto Care, our passion for cars, and our commitment to providing top-notch repair and restoration services.',
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact',
                'meta_title' => 'Contact Ultimate Auto Care | Book Your Service',
                'meta_description' => 'Get in touch with us for car repairs, restoration, or to browse our classic car inventory. Book your appointment today!',
            ],
            [
                'title' => 'Our Services',
                'slug' => 'services',
                'meta_title' => 'Premium Car Services | Diagnostics, Repair & Restoration',
                'meta_description' => 'Explore our wide range of automotive services including advanced diagnostics, engine repair, and full vintage car restoration.',
            ],
            [
                'title' => 'Shop Cars',
                'slug' => 'cars',
                'meta_title' => 'Classic Cars for Sale | Fully Restored Vintage Automotive',
                'meta_description' => 'Browse our curated collection of hand-picked, fully restored vintage cars available for sale. Find your dream classic today.',
            ],
        ];

        foreach ($pages as $page) {
            Page::updateOrCreate(['slug' => $page['slug']], $page);
        }
    }
}
