@extends('admin.layouts.app')
@section('title', 'Add New Car')
@section('page-title', 'Add New Vehicle')

@section('content')
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-8 border border-white/5 shadow-2xl">
        <form action="{{ route('admin.cars.store') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            
            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Make</label>
                    <input type="text" name="make" placeholder="e.g. Honda" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Model Name</label>
                    <input type="text" name="model" placeholder="e.g. NSX" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">VIN Number</label>
                    <input type="text" name="vin" placeholder="JH4NA..." class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Stock Number</label>
                    <input type="text" name="stock_number" placeholder="C-91NSX" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Year</label>
                    <input type="number" name="year" placeholder="1991" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Listing Price ($)</label>
                    <input type="number" name="price" placeholder="89000" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Market Avg Price ($)</label>
                    <input type="number" name="market_avg_price" placeholder="95000" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Type</label>
                    <select name="type" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="classic">Classic</option>
                        <option value="pre-owned">Pre-owned</option>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Exterior Color</label>
                    <input type="text" name="ext_color" placeholder="Formula Red" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Interior Color</label>
                    <input type="text" name="int_color" placeholder="Black Leather" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Engine</label>
                    <input type="text" name="engine" placeholder="3.0L V6 VTEC" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Drive Type</label>
                    <input type="text" name="drive_type" placeholder="RWD" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="space-y-2">
                <label class="text-sm font-bold text-slate-400 ml-1">Car Description & Details</label>
                <textarea name="description" rows="4" placeholder="Japanese supercar pinnacle..." class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all"></textarea>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Fuel Type</label>
                    <input type="text" name="fuel_type" value="Petrol" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Transmission</label>
                    <input type="text" name="transmission" value="Manual" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Mileage</label>
                    <input type="text" name="mileage" placeholder="42,086 mi" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Image</label>
                        <input type="file" name="image" class="w-full bg-white/5 border border-white/10 rounded-2xl py-3 px-6 text-white focus:outline-none transition-all">
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Image Alt Text (SEO)</label>
                        <input type="text" name="image_alt" placeholder="Describe the image for SEO" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                    </div>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Seller Name</label>
                    <input type="text" name="seller_name" value="Ultimate Auto Care" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6 p-6 bg-accent/5 rounded-3xl border border-accent/10">
                <div class="col-span-2">
                    <h3 class="text-lg font-bold text-accent mb-4">SEO Optimization</h3>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">URL Slug</label>
                    <input type="text" name="slug" placeholder="auto-generated-if-empty" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Title</label>
                    <input type="text" name="meta_title" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="col-span-2 space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Description</label>
                    <textarea name="meta_description" rows="2" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all"></textarea>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Status</label>
                    <select name="status" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="available">Available</option>
                        <option value="sold">Sold</option>
                    </select>
                </div>
                <div class="flex items-center space-x-3 pt-8">
                    <input type="checkbox" name="is_featured" value="1" id="is_featured" class="w-5 h-5 rounded border-white/10 bg-white/5 text-accent focus:ring-accent">
                    <label for="is_featured" class="text-sm font-bold text-white">Feature on Homepage</label>
                </div>
            </div>

            <div class="pt-6 border-t border-white/5 flex space-x-4">
                <button type="submit" class="flex-1 bg-accent hover:bg-accent-dark text-white py-4 rounded-2xl font-bold text-lg transition-all shadow-xl shadow-accent/20">
                    Add to Inventory
                </button>
                <a href="{{ route('admin.cars.index') }}" class="px-8 py-4 rounded-2xl bg-white/5 text-slate-400 font-bold hover:bg-white/10 transition-all border border-white/10">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
