@extends('layouts.main')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-12">
    <x-breadcrumb :items="['Blog' => route('blogs.index'), $blog->title => '']" />

    <article class="mt-12">
        <header class="mb-12">
            <h1 class="text-5xl font-black leading-tight mb-8">{{ $blog->title }}</h1>
            <div class="flex items-center space-x-6">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-accent rounded-full flex items-center justify-center text-primary font-bold">U</div>
                    <span class="text-sm font-bold">Ultimate Auto Care</span>
                </div>
                <div class="w-1.5 h-1.5 bg-white/20 rounded-full"></div>
                <time class="text-text-muted text-sm">{{ $blog->published_at->format('M d, Y') }}</time>
            </div>
        </header>

        <div class="aspect-[21/9] rounded-[2.5rem] overflow-hidden mb-12 border border-white/5">
            <img src="{{ asset($blog->featured_image ?? 'assets/images/blog-placeholder.jpg') }}" 
                 alt="{{ $blog->image_alt ?? $blog->title }}" class="w-full h-full object-cover">
        </div>

        <div class="prose prose-invert prose-lg max-w-none">
            {!! $blog->content !!}
        </div>

        <footer class="mt-20 pt-10 border-t border-white/5">
            <div class="flex flex-wrap gap-4">
                @foreach($blog->tags ?? [] as $tag)
                <span class="bg-white/5 px-4 py-2 rounded-xl text-sm italic cursor-default">#{{ $tag->name }}</span>
                @endforeach
            </div>
        </footer>
    </article>
</div>
@endsection
