<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login — Ultimate Auto Care</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;700;900&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Outfit', sans-serif; }
        body { background: #050810; }
        .glass { background: rgba(255,255,255,0.04); backdrop-filter: blur(30px); border: 1px solid rgba(255,255,255,0.1); }
        .gradient-text { background: linear-gradient(135deg, #6366f1, #a855f7, #06b6d4); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .input-field { background: rgba(255,255,255,0.04); border: 1px solid rgba(255,255,255,0.08); color: white; transition: all 0.3s; }
        .input-field:focus { outline: none; border-color: #6366f1; background: rgba(99,102,241,0.08); box-shadow: 0 0 0 3px rgba(99,102,241,0.15); }
        .btn-login { background: linear-gradient(135deg, #6366f1, #a855f7); transition: all 0.3s; }
        .btn-login:hover { transform: translateY(-2px); box-shadow: 0 20px 40px rgba(99,102,241,0.4); }
        @keyframes float { 0%,100% { transform: translateY(0) rotate(0deg); } 50% { transform: translateY(-30px) rotate(5deg); } }
        @keyframes spin-slow { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
        .float { animation: float 8s ease-in-out infinite; }
        .spin-slow { animation: spin-slow 20s linear infinite; }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center relative overflow-hidden">
    <!-- Animated BG -->
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute top-1/4 left-1/4 w-80 h-80 bg-indigo-500/10 rounded-full blur-[100px] float"></div>
        <div class="absolute bottom-1/4 right-1/4 w-80 h-80 bg-purple-500/10 rounded-full blur-[100px] float" style="animation-delay:4s"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] border border-white/3 rounded-full spin-slow opacity-20"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[400px] h-[400px] border border-indigo-500/10 rounded-full spin-slow opacity-30" style="animation-direction:reverse;animation-duration:15s"></div>
    </div>

    <div class="relative z-10 w-full max-w-md px-6">
        <!-- Logo -->
        <div class="text-center mb-10">
            <div class="w-20 h-20 rounded-3xl bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center mx-auto mb-6 shadow-2xl shadow-indigo-500/30">
                <i class="fas fa-car text-white text-3xl"></i>
            </div>
            <h1 class="text-4xl font-black gradient-text mb-2">Admin Portal</h1>
            <p class="text-slate-500 text-sm">Ultimate Auto Care Management System</p>
        </div>

        <!-- Login Card -->
        <div class="glass rounded-3xl p-8" x-data="{ showPass: false }">
            <h2 class="text-xl font-bold text-white mb-8">Sign In to Dashboard</h2>

            <?php if($errors->any()): ?>
            <div class="mb-6 bg-red-500/10 border border-red-500/30 rounded-2xl px-5 py-4 text-red-400 text-sm flex items-center space-x-3">
                <i class="fas fa-exclamation-triangle"></i>
                <span><?php echo e($errors->first()); ?></span>
            </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.login.post')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-widest mb-3">Email Address</label>
                    <div class="relative">
                        <i class="fas fa-envelope absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm"></i>
                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                               class="input-field w-full pl-12 pr-4 py-4 rounded-2xl text-sm"
                               placeholder="admin@ultimateautocare.com">
                    </div>
                </div>
                <div>
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-widest mb-3">Password</label>
                    <div class="relative">
                        <i class="fas fa-lock absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 text-sm"></i>
                        <input :type="showPass ? 'text' : 'password'" name="password" required
                               class="input-field w-full pl-12 pr-12 py-4 rounded-2xl text-sm"
                               placeholder="••••••••">
                        <button type="button" @click="showPass = !showPass" class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 hover:text-slate-300 transition-colors">
                            <i class="fas" :class="showPass ? 'fa-eye-slash' : 'fa-eye'"></i>
                        </button>
                    </div>
                </div>
                <div class="flex items-center justify-between">
                    <label class="flex items-center space-x-3 cursor-pointer">
                        <input type="checkbox" name="remember" class="w-4 h-4 rounded accent-indigo-500">
                        <span class="text-sm text-slate-400">Remember me</span>
                    </label>
                </div>
                <button type="submit" class="btn-login w-full py-4 rounded-2xl font-black text-white text-lg tracking-wide">
                    <i class="fas fa-arrow-right-to-bracket mr-3"></i> Sign In
                </button>
            </form>
        </div>

        <p class="text-center text-slate-600 text-xs mt-8">
            © <?php echo e(date('Y')); ?> Ultimate Auto Care. All rights reserved.
        </p>
    </div>
</body>
</html>
<?php /**PATH /home/u784207861/domains/shahwaizsamiahmed.com/public_html/backend/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>