
<?php $__env->startSection('title', 'Messages'); ?>
<?php $__env->startSection('page-title', 'Contact Messages'); ?>
<?php $__env->startSection('page-subtitle', 'Manage customer inquiries and messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="glass rounded-3xl p-5 mb-6 flex flex-wrap gap-4 items-center">
    <form method="GET" class="flex flex-wrap gap-3 flex-1">
        <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search messages..."
               class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white placeholder-slate-500 focus:outline-none focus:border-accent flex-1 min-w-48">
        <select name="status" class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white focus:outline-none focus:border-accent">
            <option value="">All</option>
            <?php $__currentLoopData = ['unread','read','replied']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($s); ?>" <?php echo e(request('status') == $s ? 'selected' : ''); ?> class="bg-slate-900"><?php echo e(ucfirst($s)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button type="submit" class="bg-accent hover:bg-accent-dark px-6 py-3 rounded-2xl text-white font-bold text-sm transition-colors"><i class="fas fa-search mr-2"></i>Filter</button>
        <?php if(request()->hasAny(['search','status'])): ?><a href="<?php echo e(route('admin.messages.index')); ?>" class="bg-white/5 hover:bg-white/10 px-6 py-3 rounded-2xl text-slate-400 font-bold text-sm transition-colors">Clear</a><?php endif; ?>
    </form>
</div>
<div class="glass rounded-3xl overflow-hidden">
    <table class="w-full">
        <thead><tr class="border-b border-white/5">
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">From</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden md:table-cell">Subject</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Status</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden lg:table-cell">Date</th>
            <th class="px-6 py-4 text-right text-xs font-black text-slate-500 uppercase tracking-widest">Actions</th>
        </tr></thead>
        <tbody class="divide-y divide-white/5">
            <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="hover:bg-white/3 transition-colors <?php echo e($msg->status === 'unread' ? 'bg-cyan-500/3' : ''); ?>">
                <td class="px-6 py-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-cyan-500/20 to-blue-500/20 flex items-center justify-center text-xs font-black text-neon-cyan flex-shrink-0"><?php echo e(strtoupper(substr($msg->name, 0, 1))); ?></div>
                        <div><p class="text-sm font-bold text-white <?php echo e($msg->status === 'unread' ? '' : 'font-normal'); ?>"><?php echo e($msg->name); ?></p><p class="text-xs text-slate-500"><?php echo e($msg->email); ?></p></div>
                    </div>
                </td>
                <td class="px-6 py-4 hidden md:table-cell"><p class="text-sm text-slate-400 truncate max-w-xs"><?php echo e($msg->subject ?? Str::limit($msg->message, 50)); ?></p></td>
                <td class="px-6 py-4"><span class="badge-<?php echo e($msg->status); ?> text-xs font-bold px-3 py-1.5 rounded-xl capitalize"><?php echo e($msg->status); ?></span></td>
                <td class="px-6 py-4 hidden lg:table-cell"><span class="text-xs text-slate-500"><?php echo e(\Carbon\Carbon::parse($msg->created_at)->format('M j, Y')); ?></span></td>
                <td class="px-6 py-4 text-right">
                    <div class="flex items-center justify-end space-x-2">
                        <a href="<?php echo e(route('admin.messages.show', $msg->id)); ?>" class="w-8 h-8 rounded-xl bg-accent/10 hover:bg-accent/20 flex items-center justify-center text-accent transition-colors"><i class="fas fa-eye text-xs"></i></a>
                        <form action="<?php echo e(route('admin.messages.destroy', $msg->id)); ?>" method="POST" onsubmit="return confirm('Delete?')"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?><button type="submit" class="w-8 h-8 rounded-xl bg-rose-500/10 hover:bg-rose-500/20 flex items-center justify-center text-rose-400 transition-colors"><i class="fas fa-trash text-xs"></i></button></form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="5" class="px-6 py-16 text-center text-slate-500">No messages found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php if($messages->hasPages()): ?><div class="px-6 py-4 border-t border-white/5"><?php echo e($messages->withQueryString()->links()); ?></div><?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\Cars site\ultimate-auto-admin\resources\views/admin/messages/index.blade.php ENDPATH**/ ?>