

<?php $__env->startSection('content'); ?>
<main>
    <!-- Hero Section -->
    <section class="relative min-h-screen flex items-center pt-20 overflow-hidden">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <div class="space-y-8">
                    <div>
                        <span class="inline-block glass px-4 py-1.5 rounded-full text-accent text-sm font-bold tracking-wider mb-4 border border-accent/20">
                            <?php echo e($contents['hero_badge'] ?? 'CERTIFIED CAR SPECIALISTS'); ?>

                        </span>
                        <h1 class="text-6xl md:text-7xl font-extrabold leading-tight mb-6">
                            <?php echo $contents['hero_title'] ?? 'Precision <span class="text-gradient">Care</span> for <br> Your Automotive <span class="text-gradient">Legends</span>.'; ?>

                        </h1>
                        <p class="text-text-muted text-lg max-w-lg mb-10 leading-relaxed">
                            <?php echo e($contents['hero_description'] ?? 'From high-tech computer diagnostics to complete engine restoration, we provide expert care for modern performance cars and vintage classics.'); ?>

                        </p>
                        <div class="flex flex-col sm:row items-start space-y-4 sm:space-y-0 sm:space-x-6">
                            <a href="<?php echo e(route('contact')); ?>" class="bg-accent hover:bg-accent-dark text-primary px-10 py-4 rounded-xl font-bold text-lg transition-all transform hover:scale-105 shadow-lg shadow-accent/20">
                                Book Appointment
                            </a>
                            <a href="<?php echo e(route('cars.index')); ?>" class="glass px-10 py-4 rounded-xl font-bold text-lg hover:bg-white/10 transition-all border border-white/10">
                                Browse Used Cars
                            </a>
                        </div>
                    </div>
                </div>

                <div class="relative hidden lg:block">
                    <div class="relative z-10">
                        <img src="https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?q=80&w=2072&auto=format&fit=crop" 
                             alt="Luxury Car Workshop" 
                             class="rounded-3xl shadow-2xl border border-white/5" loading="lazy">
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Featured Services Section -->
    <section class="py-24 bg-secondary/30 relative">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold mb-4">Our Elite <span class="text-accent">Services</span></h2>
                <p class="text-text-muted max-w-2xl mx-auto">Expert mechanical solutions tailored to your vehicle's specific needs using state-of-the-art diagnostic equipment.</p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $featuredServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="glass p-8 rounded-3xl group hover:bg-white/5 transition-all">
                    <div class="w-16 h-16 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-6 group-hover:bg-accent group-hover:text-primary transition-all duration-500">
                        <i class="fas <?php echo e($service->icon ?: 'fa-tools'); ?> text-3xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4"><?php echo e($service->title); ?></h3>
                    <p class="text-text-muted mb-6 leading-relaxed line-clamp-2">
                        <?php echo e($service->description); ?>

                    </p>
                    <a href="<?php echo e(route('services.show', $service->slug)); ?>" class="text-accent font-bold flex items-center space-x-2 group-hover:translate-x-2 transition-transform">
                        <span>Read More</span>
                        <i class="fas fa-arrow-right text-sm"></i>
                    </a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="mt-16 text-center">
                <a href="<?php echo e(route('services.index')); ?>" class="inline-flex items-center space-x-3 text-lg font-bold border-b-2 border-accent pb-1 hover:text-accent transition-colors">
                    <span>View All Services</span>
                    <i class="fas fa-chevron-right"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Featured Cars Section -->
    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <h2 class="text-4xl font-bold mb-12">Featured <span class="text-accent">Classics</span></h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $featuredCars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="glass rounded-3xl overflow-hidden group">
                    <div class="relative h-64 overflow-hidden">
                        <img src="<?php echo e($car->image); ?>" alt="<?php echo e($car->image_alt ?? ($car->make . ' ' . $car->model)); ?>" 
                             class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700" loading="lazy">
                    </div>
                    <div class="p-8">
                        <h3 class="text-2xl font-bold"><?php echo e($car->make); ?> <?php echo e($car->model); ?></h3>
                        <p class="text-accent text-sm font-bold"><?php echo e($car->year); ?> | <?php echo e($car->type); ?></p>
                        <p class="text-text-muted text-sm mt-4 line-clamp-2"><?php echo e($car->description); ?></p>
                        <a href="<?php echo e(route('cars.show', $car->slug)); ?>" class="block text-center mt-6 bg-accent/10 hover:bg-accent text-accent hover:text-primary font-bold py-4 rounded-xl transition-all">
                            View Details
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <?php if(isset($latestCars) && $latestCars->count() > 0): ?>
            <div class="mt-20">
                <h2 class="text-4xl font-bold mb-12">Newly <span class="text-neon-cyan">Listed</span></h2>
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php $__currentLoopData = $latestCars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="glass rounded-3xl overflow-hidden group border border-white/5 hover:border-neon-cyan/20 transition-all">
                        <div class="relative h-56 overflow-hidden">
                            <img src="<?php echo e($car->image); ?>" alt="<?php echo e($car->image_alt ?? ($car->make . ' ' . $car->model)); ?>" 
                                 class="w-full h-full object-cover">
                            <div class="absolute top-4 left-4">
                                <span class="bg-neon-cyan/20 backdrop-blur-md text-neon-cyan text-[10px] font-black px-3 py-1 rounded-full uppercase">Just Listed</span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-bold"><?php echo e($car->make); ?> <?php echo e($car->model); ?></h3>
                            <div class="flex justify-between items-center mt-4">
                                <span class="text-white font-black">$<?php echo e(number_format($car->price)); ?></span>
                                <a href="<?php echo e(route('cars.show', $car->slug)); ?>" class="text-neon-cyan text-xs font-bold hover:underline">View Car →</a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/u784207861/domains/shahwaizsamiahmed.com/public_html/backend/resources/views/home.blade.php ENDPATH**/ ?>