<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use App\Models\AdminUser;
use Illuminate\Support\Facades\Auth;

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$kernel->bootstrap();
$request = Illuminate\Http\Request::capture();

$admin = AdminUser::first();
Auth::guard('admin')->login($admin);

echo "Admin logged in: " . $admin->email . "\n";

$response = $kernel->handle(
    $request = Illuminate\Http\Request::create('/admin/dashboard', 'GET')
);

echo "Status Code: " . $response->getStatusCode() . "\n";
if ($response->isRedirect()) {
    echo "Redirected to: " . $response->headers->get('Location') . "\n";
} else {
    echo "Content length: " . strlen($response->getContent()) . "\n";
    echo "Snippet: " . substr(strip_tags($response->getContent()), 0, 200) . "\n";
}
