<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function showLogin()
    {
        if (Auth::guard('admin')->check()) {
            return redirect()->route('admin.dashboard');
        }
        return view('admin.auth.login');
    }

    public function login(Request $request)
    {
        global $conn;
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        // Use $conn as requested
        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE email = ? AND is_active = 1 LIMIT 1");
        $stmt->execute([$credentials['email']]);
        $adminData = $stmt->fetch();

        if ($adminData && Hash::check($credentials['password'], $adminData['password'])) {
            // Still need the model for Laravel's Auth guard to function
            $admin = AdminUser::find($adminData['id']);
            Auth::guard('admin')->login($admin, $request->boolean('remember'));
            
            // Log login time using $conn
            $logStmt = $conn->prepare("UPDATE admin_users SET last_login_at = NOW() WHERE id = ?");
            $logStmt->execute([$adminData['id']]);
            
            return redirect()->route('admin.dashboard');
        }

        return back()->withErrors(['email' => 'Invalid credentials.'])->withInput();
    }

    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login');
    }
}
