<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FinancingApplication;
use Illuminate\Http\Request;

class FinancingController extends Controller
{
    public function index(Request $request)
    {
        global $conn;
        $sql = "SELECT * FROM financing_applications WHERE 1=1";
        $params = [];

        if ($request->filled('status')) {
            $sql .= " AND status = ?";
            $params[] = $request->status;
        }
        if ($request->filled('type')) {
            $sql .= " AND application_type = ?";
            $params[] = $request->type;
        }
        if ($request->filled('search')) {
            $s = "%" . $request->search . "%";
            $sql .= " AND (first_name LIKE ? OR last_name LIKE ? OR email LIKE ?)";
            $params[] = $s; $params[] = $s; $params[] = $s;
        }

        $sql .= " ORDER BY created_at DESC";
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $applications_raw = $stmt->fetchAll();
        $applications = array_map(function($item) {
            $obj = (object)$item;
            $obj->full_name = ($obj->first_name ?? '') . ' ' . ($obj->last_name ?? '');
            return $obj;
        }, $applications_raw);

        return view('admin.financing.index', compact('applications'));
    }

    public function show($id)
    {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM financing_applications WHERE id = ? LIMIT 1");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        if (!$row) abort(404);
        
        $application = (object)$row;
        $application->full_name = ($application->first_name ?? '') . ' ' . ($application->last_name ?? '');
        
        return view('admin.financing.show', compact('application'));
    }

    public function updateStatus(Request $request, $id)
    {
        global $conn;
        $request->validate(['status' => 'required|in:pending,reviewing,approved,rejected']);
        
        $upd = $conn->prepare("UPDATE financing_applications SET status = ?, admin_notes = ? WHERE id = ?");
        $upd->execute([$request->status, $request->admin_notes, $id]);
        
        return back()->with('success', 'Application status updated successfully.');
    }

    public function destroy($id)
    {
        global $conn;
        $del = $conn->prepare("DELETE FROM financing_applications WHERE id = ?");
        $del->execute([$id]);
        
        return redirect()->route('admin.financing.index')->with('success', 'Application deleted.');
    }
}
