<?php

namespace App\Http\Middleware;

use App\Models\Redirect;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RedirectMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        global $conn;
        $path = $request->path();
        $stmt = $conn->prepare("SELECT * FROM redirects WHERE old_url = ? OR old_url = ? LIMIT 1");
        $stmt->execute([$path, '/' . $path]);
        $redirect = $stmt->fetch();

        if ($redirect) {
            return redirect($redirect['new_url'], $redirect['type']);
        }

        return $next($request);
    }
}
