<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasSlug;

    protected $fillable = [
        'title', 'slug', 'page_name',
        'meta_title', 'meta_description', 'canonical_url', 'og_title', 
        'og_description', 'og_image', 'schema_json', 'is_index'
    ];

    protected $casts = [
        'is_index' => 'boolean',
        'schema_json' => 'array',
    ];
}
