<?php

namespace App\Traits;

use Illuminate\Support\Str;

trait HasSlug
{
    protected static function bootHasSlug()
    {
        static::creating(function ($model) {
            if (empty($model->slug)) {
                $model->slug = $model->generateUniqueSlug($model->title ?? $model->name ?? $model->make . ' ' . $model->model);
            }
        });

        static::updating(function ($model) {
            if ($model->isDirty('title') || $model->isDirty('name') || ($model->isDirty('make') || $model->isDirty('model'))) {
                // Only auto-update slug if it was empty or matches old title
                // Usually admins want to keep slugs stable for SEO, but here we provide auto-gen.
                // We'll allow manual edits too.
            }
        });
    }

    public function generateUniqueSlug($title)
    {
        $slug = Str::slug($title);
        $count = static::where('slug', 'LIKE', "{$slug}%")->count();

        return $count ? "{$slug}-" . ($count + 1) : $slug;
    }
}
