<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('cars', function (Blueprint $table) {
            $table->string('vin')->nullable()->after('model');
            $table->string('stock_number')->nullable()->after('vin');
            $table->string('ext_color')->nullable()->after('mileage');
            $table->string('int_color')->nullable()->after('ext_color');
            $table->string('engine')->nullable()->after('int_color');
            $table->string('drive_type')->nullable()->after('engine');
            $table->decimal('market_avg_price', 15, 2)->nullable()->after('price');
            $table->string('seller_name')->default('Ultimate Auto Care')->after('status');
        });
    }

    public function down(): void
    {
        Schema::table('cars', function (Blueprint $table) {
            $table->dropColumn(['vin', 'stock_number', 'ext_color', 'int_color', 'engine', 'drive_type', 'market_avg_price', 'seller_name']);
        });
    }
};
