<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add SEO columns to existing cars table
        Schema::table('cars', function (Blueprint $table) {
            $table->string('meta_title', 255)->nullable();
            $table->text('meta_description')->nullable();
            $table->string('slug')->unique()->nullable(); // Making it nullable first to handle existing records
            $table->string('canonical_url')->nullable();
            $table->string('og_title')->nullable();
            $table->text('og_description')->nullable();
            $table->string('og_image')->nullable();
            $table->longText('schema_json')->nullable();
            $table->boolean('is_index')->default(true);
            $table->string('image_alt')->nullable();
        });

        // Create services table
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->text('content')->nullable();
            $table->string('featured_image')->nullable();
            $table->string('image_alt')->nullable();
            
            // SEO Fields
            $table->string('meta_title', 255)->nullable();
            $table->text('meta_description')->nullable();
            $table->string('canonical_url')->nullable();
            $table->string('og_title')->nullable();
            $table->text('og_description')->nullable();
            $table->string('og_image')->nullable();
            $table->longText('schema_json')->nullable();
            $table->boolean('is_index')->default(true);
            
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Create pages table (for static pages like Home, About, Contact)
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique(); // 'home', 'about', 'contact'
            $table->string('page_name')->nullable(); // Optional reference to internal identifier
            
            // SEO Fields
            $table->string('meta_title', 255)->nullable();
            $table->text('meta_description')->nullable();
            $table->string('canonical_url')->nullable();
            $table->string('og_title')->nullable();
            $table->text('og_description')->nullable();
            $table->string('og_image')->nullable();
            $table->longText('schema_json')->nullable();
            $table->boolean('is_index')->default(true);
            
            $table->timestamps();
        });

        // Create blogs table (Step 5)
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->longText('content')->nullable();
            $table->string('featured_image')->nullable();
            $table->string('image_alt')->nullable();
            $table->string('status')->default('draft'); // draft, published
            $table->timestamp('published_at')->nullable();
            
            // SEO Fields
            $table->string('meta_title', 255)->nullable();
            $table->text('meta_description')->nullable();
            $table->longText('schema_json')->nullable();
            $table->string('canonical_url')->nullable();
            $table->string('og_title')->nullable();
            $table->text('og_description')->nullable();
            $table->string('og_image')->nullable();
            $table->boolean('is_index')->default(true);
            
            $table->timestamps();
        });

        // Redirects table (Step 7)
        Schema::create('redirects', function (Blueprint $table) {
            $table->id();
            $table->string('old_url');
            $table->string('new_url');
            $table->integer('type')->default(301); // 301 or 302
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('redirects');
        Schema::dropIfExists('blogs');
        Schema::dropIfExists('pages');
        Schema::dropIfExists('services');
        Schema::table('cars', function (Blueprint $table) {
            $table->dropColumn([
                'meta_title', 'meta_description', 'slug', 'canonical_url', 
                'og_title', 'og_description', 'og_image', 'schema_json', 
                'is_index', 'image_alt'
            ]);
        });
    }
};
