@extends('admin.layouts.app')
@section('title', 'Edit Vehicle')
@section('page-title', 'Edit: ' . $car->make . ' ' . $car->model)

@section('content')
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-8 border border-white/5 shadow-2xl">
        <form action="{{ route('admin.cars.update', $car) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PATCH')
            
            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Make</label>
                    <input type="text" name="make" value="{{ $car->make }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Model Name</label>
                    <input type="text" name="model" value="{{ $car->model }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">VIN Number</label>
                    <input type="text" name="vin" value="{{ $car->vin }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Stock Number</label>
                    <input type="text" name="stock_number" value="{{ $car->stock_number }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Year</label>
                    <input type="number" name="year" value="{{ $car->year }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Listing Price ($)</label>
                    <input type="number" name="price" value="{{ (int)$car->price }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Market Avg Price ($)</label>
                    <input type="number" name="market_avg_price" value="{{ (int)$car->market_avg_price }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Type</label>
                    <select name="type" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="classic" {{ $car->type == 'classic' ? 'selected' : '' }}>Classic</option>
                        <option value="pre-owned" {{ $car->type == 'pre-owned' ? 'selected' : '' }}>Pre-owned</option>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Exterior Color</label>
                    <input type="text" name="ext_color" value="{{ $car->ext_color }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Interior Color</label>
                    <input type="text" name="int_color" value="{{ $car->int_color }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Engine</label>
                    <input type="text" name="engine" value="{{ $car->engine }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Drive Type</label>
                    <input type="text" name="drive_type" value="{{ $car->drive_type }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="space-y-2">
                <label class="text-sm font-bold text-slate-400 ml-1">Car Description & Details</label>
                <textarea name="description" rows="4" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">{{ $car->description }}</textarea>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Fuel Type</label>
                    <input type="text" name="fuel_type" value="{{ $car->fuel_type }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Transmission</label>
                    <input type="text" name="transmission" value="{{ $car->transmission }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Mileage</label>
                    <input type="text" name="mileage" value="{{ $car->mileage }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Update Image</label>
                        <div class="flex items-center space-x-4">
                            @if($car->image)
                            <img src="{{ $car->image }}" class="w-20 h-12 rounded-lg object-cover border border-white/10">
                            @endif
                            <input type="file" name="image" class="w-full bg-white/5 border border-white/10 rounded-2xl py-2 px-6 text-white focus:outline-none transition-all">
                        </div>
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Image Alt Text (SEO)</label>
                        <input type="text" name="image_alt" value="{{ $car->image_alt }}" placeholder="Describe the image for screen readers and SEO" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                    </div>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Seller Name</label>
                    <input type="text" name="seller_name" value="{{ $car->seller_name }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6 p-6 bg-accent/5 rounded-3xl border border-accent/10">
                <div class="col-span-2">
                    <h3 class="text-lg font-bold text-accent mb-4">SEO Optimization</h3>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">URL Slug</label>
                    <input type="text" name="slug" value="{{ $car->slug }}" placeholder="auto-generated-if-empty" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Title</label>
                    <input type="text" name="meta_title" value="{{ $car->meta_title }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="col-span-2 space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Description</label>
                    <textarea name="meta_description" rows="2" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">{{ $car->meta_description }}</textarea>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Status</label>
                    <select name="status" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="available" {{ $car->status == 'available' ? 'selected' : '' }}>Available</option>
                        <option value="sold" {{ $car->status == 'sold' ? 'selected' : '' }}>Sold</option>
                    </select>
                </div>
                <div class="flex items-center space-x-3 pt-8">
                    <input type="checkbox" name="is_featured" value="1" id="is_featured" {{ $car->is_featured ? 'checked' : '' }} class="w-5 h-5 rounded border-white/10 bg-white/5 text-accent focus:ring-accent">
                    <label for="is_featured" class="text-sm font-bold text-white">Feature on Homepage</label>
                </div>
            </div>

            <div class="pt-6 border-t border-white/5 flex space-x-4">
                <button type="submit" class="flex-1 bg-accent hover:bg-accent-dark text-white py-4 rounded-2xl font-bold text-lg transition-all shadow-xl shadow-accent/20">
                    Update Vehicle
                </button>
                <a href="{{ route('admin.cars.index') }}" class="px-8 py-4 rounded-2xl bg-white/5 text-slate-400 font-bold hover:bg-white/10 transition-all border border-white/10">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
