@extends('admin.layouts.app')
@section('title', 'Message from ' . $message->name)
@section('page-title', 'Message from ' . $message->name)
@section('page-subtitle', $message->email)

@section('content')
<div class="grid lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-6">
        <div class="glass rounded-3xl p-6">
            <div class="flex items-center justify-between mb-5">
                <h3 class="font-black text-white">Message</h3>
                <span class="badge-{{ $message->status }} text-xs font-bold px-3 py-1.5 rounded-xl capitalize">{{ $message->status }}</span>
            </div>
            @if($message->subject)<p class="text-xs font-black text-slate-500 uppercase tracking-widest mb-2">Subject: <span class="text-slate-300 normal-case font-semibold">{{ $message->subject }}</span></p>@endif
            <div class="bg-white/3 rounded-2xl p-5 text-slate-300 leading-relaxed">{{ $message->message }}</div>
        </div>
        @if($message->admin_reply)
        <div class="glass rounded-3xl p-6 border border-emerald-500/20">
            <h3 class="font-black text-emerald-400 mb-4"><i class="fas fa-reply mr-2"></i>Your Reply</h3>
            <div class="bg-emerald-500/5 rounded-2xl p-5 text-slate-300 leading-relaxed">{{ $message->admin_reply }}</div>
        </div>
        @endif
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-4">{{ $message->admin_reply ? 'Update Reply' : 'Reply' }}</h3>
            <form action="{{ route('admin.messages.reply', $message->id) }}" method="POST" class="space-y-4">
                @csrf
                <textarea name="admin_reply" rows="5" class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-4 text-white text-sm focus:outline-none focus:border-accent resize-none" placeholder="Type your reply...">{{ $message->admin_reply }}</textarea>
                <button type="submit" class="bg-accent hover:bg-accent-dark px-8 py-3 rounded-2xl font-bold text-white text-sm transition-colors"><i class="fas fa-paper-plane mr-2"></i>Save Reply</button>
            </form>
        </div>
    </div>
    <div class="space-y-6">
        <div class="glass rounded-3xl p-6 space-y-4">
            <h3 class="font-black text-white">Sender Info</h3>
            <div class="space-y-3 text-sm">
                <div><p class="text-[10px] text-slate-500 uppercase tracking-widest mb-1">Name</p><p class="font-bold text-white">{{ $message->name }}</p></div>
                <div><p class="text-[10px] text-slate-500 uppercase tracking-widest mb-1">Email</p><a href="mailto:{{ $message->email }}" class="font-bold text-accent hover:underline">{{ $message->email }}</a></div>
                @if($message->phone)<div><p class="text-[10px] text-slate-500 uppercase tracking-widest mb-1">Phone</p><p class="font-bold text-white">{{ $message->phone }}</p></div>@endif
                <div><p class="text-[10px] text-slate-500 uppercase tracking-widest mb-1">Received</p><p class="font-bold text-white">{{ \Carbon\Carbon::parse($message->created_at)->format('M j, Y g:i A') }}</p></div>
                <div><p class="text-[10px] text-slate-500 uppercase tracking-widest mb-1">IP Address</p><p class="font-bold text-white">{{ $message->ip_address ?? 'N/A' }}</p></div>
            </div>
        </div>
        <a href="{{ route('admin.messages.index') }}" class="flex items-center justify-center space-x-2 glass rounded-2xl py-3 text-slate-400 hover:text-white transition-colors text-sm font-bold"><i class="fas fa-arrow-left"></i><span>Back to Messages</span></a>
    </div>
</div>
@endsection
