@extends('admin.layouts.app')
@section('title', 'Service Management')
@section('page-title', 'Automotive Services')

@section('content')
<div class="flex flex-col space-y-6">
    <div class="flex justify-between items-center">
        <div>
            <p class="text-slate-400">Manage your automotive service offerings and their SEO content.</p>
            <div class="flex items-center space-x-6 mt-2">
                <div class="flex items-center space-x-2">
                    <span class="text-xs font-black text-slate-500 uppercase tracking-widest">Total:</span>
                    <span class="text-white font-bold">{{ count($services) }}</span>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="text-xs font-black text-slate-500 uppercase tracking-widest">Optimized:</span>
                    <span class="text-neon-green font-bold">{{ count(array_filter($services, fn($s) => !empty($s->meta_title))) }}</span>
                </div>
            </div>
        </div>
        <a href="{{ route('admin.services.create') }}" class="bg-accent hover:bg-accent-dark text-white px-6 py-3 rounded-xl font-bold transition-all flex items-center shadow-lg shadow-accent/20">
            <i class="fas fa-plus mr-2"></i> Add New Service
        </a>
    </div>

    <div class="glass-strong rounded-3xl overflow-hidden border border-white/5">
        <table class="w-full text-left">
            <thead>
                <tr class="bg-white/5 text-slate-400 text-xs uppercase tracking-widest font-black">
                    <th class="px-6 py-4">Service</th>
                    <th class="px-6 py-4">URL Slug</th>
                    <th class="px-6 py-4">SEO Score</th>
                    <th class="px-6 py-4">Status</th>
                    <th class="px-6 py-4 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-white/5">
                @foreach($services as $service)
                <tr class="group hover:bg-white/5 transition-colors">
                    <td class="px-6 py-4">
                        <div class="flex items-center space-x-4">
                            <div class="w-12 h-12 rounded-xl overflow-hidden glass border border-white/10">
                                <img src="{{ $service->featured_image ?? 'https://images.unsplash.com/photo-1581092160562-40aa08e78837?q=80&w=200&auto=format&fit=crop' }}" class="w-full h-full object-cover">
                            </div>
                            <div>
                                <p class="font-bold text-white">{{ $service->title }}</p>
                                <p class="text-xs text-slate-500 italic">{{ Str::limit($service->description, 40) }}</p>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 font-mono text-xs text-slate-400">/service/{{ $service->slug }}</td>
                    <td class="px-6 py-4">
                        <div class="flex items-center space-x-2">
                            <div class="w-2 h-2 rounded-full {{ $service->meta_title && $service->meta_description ? 'bg-neon-green' : 'bg-neon-amber' }}"></div>
                            <span class="text-xs">{{ $service->meta_title && $service->meta_description ? 'Optimized' : 'Needs Meta' }}</span>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-3 py-1 rounded-full text-[10px] font-black uppercase {{ $service->is_active ? 'badge-approved' : 'badge-rejected' }}">
                            {{ $service->is_active ? 'Active' : 'Hidden' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex justify-end space-x-2">
                            <a href="{{ route('admin.services.edit', $service->id) }}" class="w-8 h-8 rounded-lg glass flex items-center justify-center text-slate-400 hover:text-accent transition-all">
                                <i class="fas fa-edit text-xs"></i>
                            </a>
                            <form action="{{ route('admin.services.destroy', $service->id) }}" method="POST" onsubmit="return confirm('Delete this service?')">
                                @csrf @method('DELETE')
                                <button class="w-8 h-8 rounded-lg glass flex items-center justify-center text-slate-400 hover:text-neon-rose transition-all">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
