@extends('layouts.main')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-12">
    <div class="mb-12">
        <h1 class="text-6xl font-black mb-4">Premium <span class="text-gradient">Collection</span></h1>
        <p class="text-text-muted text-lg max-w-2xl">Browse our hand-picked inventory of fully restored vintage classics and performance modern cars.</p>
    </div>

    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach($cars as $car)
        <div class="glass rounded-[2rem] overflow-hidden group border border-white/5 hover:border-accent/20 transition-all">
            <div class="relative h-72 overflow-hidden">
                <img src="{{ $car->image }}" alt="{{ $car->image_alt ?? ($car->make . ' ' . $car->model) }}" 
                     class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700" loading="lazy">
                <div class="absolute top-4 right-4 bg-primary/80 backdrop-blur-md px-4 py-2 rounded-full border border-white/10">
                    <span class="text-accent font-black">${{ number_format($car->price) }}</span>
                </div>
            </div>
            <div class="p-8">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h3 class="text-2xl font-bold">{{ $car->make }} {{ $car->model }}</h3>
                        <p class="text-slate-400 text-sm italic">{{ $car->year }} | {{ $car->transmission }}</p>
                    </div>
                </div>
                
                <div class="grid grid-cols-2 gap-4 mb-8">
                    <div class="flex items-center space-x-2 text-xs text-slate-500">
                        <i class="fas fa-tachometer-alt text-accent"></i>
                        <span>{{ $car->mileage }}</span>
                    </div>
                    <div class="flex items-center space-x-2 text-xs text-slate-500">
                        <i class="fas fa-gas-pump text-accent"></i>
                        <span>{{ $car->fuel_type }}</span>
                    </div>
                </div>

                <a href="{{ route('cars.show', $car->slug) }}" class="block text-center bg-accent/10 hover:bg-accent text-accent hover:text-primary font-bold py-4 rounded-2xl transition-all">
                    View Specs & Details
                </a>
            </div>
        </div>
        @endforeach
    </div>

    <div class="mt-12">
        {{ $cars->links() }}
    </div>
</div>
@endsection
