<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="index, follow">
    
    {{-- SEO TAGS --}}
    <title>{{ $meta_title ?? 'Ultimate Auto Care | Premium Car Repair & Restored Classics' }}</title>
    <meta name="description" content="{{ $meta_description ?? 'Expert car repair services and premium vintage cars for sale.' }}">
    
    @if(!empty($canonical_url))
        <link rel="canonical" href="{{ $canonical_url }}">
    @endif

    @if(($is_index ?? true) === false)
        <meta name="robots" content="noindex, nofollow">
    @endif

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ $og_title ?? $meta_title ?? 'Ultimate Auto Care' }}">
    <meta property="og:description" content="{{ $og_description ?? $meta_description ?? '' }}">
    <meta property="og:image" content="{{ asset($og_image ?? 'assets/images/og-default.jpg') }}">
    <meta property="og:type" content="{{ $og_type ?? 'website' }}">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $og_title ?? $meta_title ?? 'Ultimate Auto Care' }}">
    <meta name="twitter:description" content="{{ $og_description ?? $meta_description ?? '' }}">
    <meta name="twitter:image" content="{{ asset($og_image ?? 'assets/images/og-default.jpg') }}">

    {{-- JSON-LD Schema --}}
    @if(!empty($schema_json))
        <script type="application/ld+json">
            {!! is_array($schema_json) ? json_encode($schema_json) : $schema_json !!}
        </script>
    @endif

    {{-- Local Business Schema --}}
    <x-local-business-schema />

    {{-- Custom Tracking Codes --}}
    {!! \App\Models\Setting::where('key', 'header_scripts')->value('value') !!}

    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0f172a',
                        secondary: '#1e293b',
                        accent: '#facc15',
                        'accent-dark': '#eab308',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif'],
                        display: ['Outfit', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    
    <!-- Custom CSS -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&family=Outfit:wght@400;600;700;800;900&display=swap');

        .glass { background: rgba(255, 255, 255, 0.03); backdrop-filter: blur(10px); }
        .nav-blur { background: rgba(15, 23, 42, 0.8); backdrop-filter: blur(12px); border-bottom: 1px solid rgba(255, 255, 255, 0.05); }
        .text-gradient { background: linear-gradient(135deg, #facc15 0%, #eab308 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
    </style>
    @stack('styles')
</head>
<body class="bg-primary text-white">

    {{-- Navigation from header.php --}}
    <nav class="fixed w-full z-50 nav-blur" x-data="{ mobileMenuOpen: false, scrolled: false }" 
         @scroll.window="scrolled = (window.pageYOffset > 20)">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <a href="{{ url('/') }}" class="flex items-center space-x-2 group">
                    <div class="w-10 h-10 bg-accent rounded-lg flex items-center justify-center transform group-hover:rotate-12 transition-transform">
                        <i class="fas fa-car-side text-primary text-xl"></i>
                    </div>
                    <span class="text-2xl font-display font-bold tracking-tight">Ultimate<span class="text-accent">AutoCare</span></span>
                </a>

                <div class="hidden md:flex items-center space-x-8">
                    <a href="{{ url('/') }}" class="text-sm font-medium hover:text-accent transition-colors">Home</a>
                    <a href="{{ route('services.index') }}" class="text-sm font-medium hover:text-accent transition-colors">Services</a>
                    <a href="{{ route('cars.index') }}" class="text-sm font-medium hover:text-accent transition-colors">Shop Cars</a>
                    <a href="{{ route('blogs.index') }}" class="text-sm font-medium hover:text-accent transition-colors">Blog</a>
                    <a href="{{ route('about') }}" class="text-sm font-medium hover:text-accent transition-colors">About</a>
                    <a href="{{ route('contact') }}" class="bg-accent hover:bg-accent-dark text-primary px-6 py-2.5 rounded-full text-sm font-bold transition-all transform hover:scale-105">
                        Book Service
                    </a>
                </div>

                <div class="md:hidden flex items-center">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" class="text-gray-300 hover:text-white">
                        <i class="fas" :class="mobileMenuOpen ? 'fa-times' : 'fa-bars'"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <div class="pt-20">
        @yield('content')
    </div>

    {{-- Footer placeholder --}}
    <footer class="bg-secondary/30 py-12 border-t border-white/5 mt-20">
        <div class="max-w-7xl mx-auto px-4 text-center">
            <p class="text-text-muted">&copy; {{ date('Y') }} Ultimate Auto Care. All rights reserved.</p>
        </div>
    </footer>

    @stack('scripts')
</body>
</html>
