<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\FormSubmissionController;

Route::prefix('v1')->middleware('throttle:60,1')->group(function () {
    Route::post('/financing/apply', [FormSubmissionController::class, 'submitFinancing']);
    Route::post('/contact', [FormSubmissionController::class, 'submitContact']);
    Route::post('/booking', [FormSubmissionController::class, 'submitBooking']);
    Route::post('/newsletter/subscribe', [FormSubmissionController::class, 'subscribeNewsletter']);
    
    // Public data
    Route::get('/cars', [\App\Http\Controllers\Api\FrontendController::class, 'getCars']);
    Route::get('/page-content', [\App\Http\Controllers\Api\FrontendController::class, 'getPageContent']);
});
