<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FinancingController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Admin\MessagesController;
use App\Http\Controllers\Admin\BookingsController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\BlogController;

// Frontend Routes
Route::get('/', [FrontendController::class, 'index'])->name('home');
Route::get('/about', [FrontendController::class, 'about'])->name('about');
Route::get('/contact', [FrontendController::class, 'contact'])->name('contact');

Route::get('/services', [FrontendController::class, 'services'])->name('services.index');
Route::get('/service/{slug}', [FrontendController::class, 'serviceDetail'])->name('services.show');

Route::get('/cars', [FrontendController::class, 'cars'])->name('cars.index');
Route::get('/car/{slug}', [FrontendController::class, 'carDetail'])->name('cars.show');

Route::get('/blog', [BlogController::class, 'index'])->name('blogs.index');
Route::get('/blog/{slug}', [BlogController::class, 'show'])->name('blogs.show');

Route::get('/sitemap.xml', [FrontendController::class, 'sitemap'])->name('sitemap');
Route::get('/sitemap_index.xml', [FrontendController::class, 'sitemapIndex'])->name('sitemap.index');

// Admin Auth Routes
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // Protected Admin Routes
    Route::middleware(\App\Http\Middleware\AdminAuthenticate::class)->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/', fn() => redirect()->route('admin.dashboard'));

        // Financing Applications
        Route::prefix('financing')->name('financing.')->group(function () {
            Route::get('/', [FinancingController::class, 'index'])->name('index');
            Route::get('/{application}', [FinancingController::class, 'show'])->name('show');
            Route::patch('/{application}/status', [FinancingController::class, 'updateStatus'])->name('status');
            Route::delete('/{application}', [FinancingController::class, 'destroy'])->name('destroy');
        });

        // Messages
        Route::prefix('messages')->name('messages.')->group(function () {
            Route::get('/', [MessagesController::class, 'index'])->name('index');
            Route::get('/{message}', [MessagesController::class, 'show'])->name('show');
            Route::post('/{message}/reply', [MessagesController::class, 'reply'])->name('reply');
            Route::delete('/{message}', [MessagesController::class, 'destroy'])->name('destroy');
        });

        // Bookings
        Route::prefix('bookings')->name('bookings.')->group(function () {
            Route::get('/', [BookingsController::class, 'index'])->name('index');
            Route::get('/{booking}', [BookingsController::class, 'show'])->name('show');
            Route::patch('/{booking}/status', [BookingsController::class, 'updateStatus'])->name('status');
            Route::delete('/{booking}', [BookingsController::class, 'destroy'])->name('destroy');
        });

        // User Management
        Route::resource('users', UserManagementController::class)->names('users');

        // Car Inventory
        Route::resource('cars', \App\Http\Controllers\Admin\CarsController::class)->names('cars');

        // Services Management
        Route::resource('services', \App\Http\Controllers\Admin\ServiceController::class)->names('services');

        // Blog Management
        Route::resource('blogs', \App\Http\Controllers\Admin\BlogManagementController::class)->names('blogs');

        // CMS / Page Builder
        Route::prefix('cms')->name('cms.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\CmsController::class, 'index'])->name('index');
            Route::get('/{page_name}', [\App\Http\Controllers\Admin\CmsController::class, 'editPage'])->name('edit');
            Route::post('/update', [\App\Http\Controllers\Admin\CmsController::class, 'updateContent'])->name('update');
        });
        
        // SEO Settings
        Route::get('/settings/seo', [\App\Http\Controllers\Admin\DashboardController::class, 'seoSettings'])->name('settings.seo');
        Route::post('/settings/seo', [\App\Http\Controllers\Admin\DashboardController::class, 'updateSeoSettings'])->name('settings.seo.update');
    });
});
