<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="index, follow">
    
    
    <title><?php echo e($meta_title ?? 'Ultimate Auto Care | Premium Car Repair & Restored Classics'); ?></title>
    <meta name="description" content="<?php echo e($meta_description ?? 'Expert car repair services and premium vintage cars for sale.'); ?>">
    
    <?php if(!empty($canonical_url)): ?>
        <link rel="canonical" href="<?php echo e($canonical_url); ?>">
    <?php endif; ?>

    <?php if(($is_index ?? true) === false): ?>
        <meta name="robots" content="noindex, nofollow">
    <?php endif; ?>

    
    <meta property="og:title" content="<?php echo e($og_title ?? $meta_title ?? 'Ultimate Auto Care'); ?>">
    <meta property="og:description" content="<?php echo e($og_description ?? $meta_description ?? ''); ?>">
    <meta property="og:image" content="<?php echo e(asset($og_image ?? 'assets/images/og-default.jpg')); ?>">
    <meta property="og:type" content="<?php echo e($og_type ?? 'website'); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($og_title ?? $meta_title ?? 'Ultimate Auto Care'); ?>">
    <meta name="twitter:description" content="<?php echo e($og_description ?? $meta_description ?? ''); ?>">
    <meta name="twitter:image" content="<?php echo e(asset($og_image ?? 'assets/images/og-default.jpg')); ?>">

    
    <?php if(!empty($schema_json)): ?>
        <script type="application/ld+json">
            <?php echo is_array($schema_json) ? json_encode($schema_json) : $schema_json; ?>

        </script>
    <?php endif; ?>

    
    <?php if (isset($component)) { $__componentOriginal3a65112833431e7341dfe3b7efc3b113 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3a65112833431e7341dfe3b7efc3b113 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.local-business-schema','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('local-business-schema'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3a65112833431e7341dfe3b7efc3b113)): ?>
<?php $attributes = $__attributesOriginal3a65112833431e7341dfe3b7efc3b113; ?>
<?php unset($__attributesOriginal3a65112833431e7341dfe3b7efc3b113); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3a65112833431e7341dfe3b7efc3b113)): ?>
<?php $component = $__componentOriginal3a65112833431e7341dfe3b7efc3b113; ?>
<?php unset($__componentOriginal3a65112833431e7341dfe3b7efc3b113); ?>
<?php endif; ?>

    
    <?php echo \App\Models\Setting::where('key', 'header_scripts')->value('value'); ?>


    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0f172a',
                        secondary: '#1e293b',
                        accent: '#facc15',
                        'accent-dark': '#eab308',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif'],
                        display: ['Outfit', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    
    <!-- Custom CSS -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&family=Outfit:wght@400;600;700;800;900&display=swap');

        .glass { background: rgba(255, 255, 255, 0.03); backdrop-filter: blur(10px); }
        .nav-blur { background: rgba(15, 23, 42, 0.8); backdrop-filter: blur(12px); border-bottom: 1px solid rgba(255, 255, 255, 0.05); }
        .text-gradient { background: linear-gradient(135deg, #facc15 0%, #eab308 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-primary text-white">

    
    <nav class="fixed w-full z-50 nav-blur" x-data="{ mobileMenuOpen: false, scrolled: false }" 
         @scroll.window="scrolled = (window.pageYOffset > 20)">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <a href="<?php echo e(url('/')); ?>" class="flex items-center space-x-2 group">
                    <div class="w-10 h-10 bg-accent rounded-lg flex items-center justify-center transform group-hover:rotate-12 transition-transform">
                        <i class="fas fa-car-side text-primary text-xl"></i>
                    </div>
                    <span class="text-2xl font-display font-bold tracking-tight">Ultimate<span class="text-accent">AutoCare</span></span>
                </a>

                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?php echo e(url('/')); ?>" class="text-sm font-medium hover:text-accent transition-colors">Home</a>
                    <a href="<?php echo e(route('services.index')); ?>" class="text-sm font-medium hover:text-accent transition-colors">Services</a>
                    <a href="<?php echo e(route('cars.index')); ?>" class="text-sm font-medium hover:text-accent transition-colors">Shop Cars</a>
                    <a href="<?php echo e(route('blogs.index')); ?>" class="text-sm font-medium hover:text-accent transition-colors">Blog</a>
                    <a href="<?php echo e(route('about')); ?>" class="text-sm font-medium hover:text-accent transition-colors">About</a>
                    <a href="<?php echo e(route('contact')); ?>" class="bg-accent hover:bg-accent-dark text-primary px-6 py-2.5 rounded-full text-sm font-bold transition-all transform hover:scale-105">
                        Book Service
                    </a>
                </div>

                <div class="md:hidden flex items-center">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" class="text-gray-300 hover:text-white">
                        <i class="fas" :class="mobileMenuOpen ? 'fa-times' : 'fa-bars'"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <div class="pt-20">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    
    <footer class="bg-secondary/30 py-12 border-t border-white/5 mt-20">
        <div class="max-w-7xl mx-auto px-4 text-center">
            <p class="text-text-muted">&copy; <?php echo e(date('Y')); ?> Ultimate Auto Care. All rights reserved.</p>
        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/u784207861/domains/shahwaizsamiahmed.com/public_html/laravel-core/resources/views/layouts/main.blade.php ENDPATH**/ ?>