<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'car-financing.php');
?>

<main class="overflow-hidden">
    <!-- Hero Section with Background Image -->
    <section class="relative min-h-[60vh] flex items-center pt-32 pb-20 mt-[-80px]">
        <div class="absolute inset-0 z-0">
            <img src="https://media.istockphoto.com/id/1419445205/photo/new-cars-in-showroom-interior-blurred-abstract-background.jpg?s=612x612&w=0&k=20&c=fgh6DXmHK9-IAqDr8BbUObV3uXuEzJrlKVBFsp7Ntk0=" 
                 alt="Showroom Background" 
                 class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-primary/40 backdrop-blur-[1px]"></div>
            <div class="absolute inset-0 bg-gradient-to-b from-transparent via-primary/20 to-primary"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full text-center" 
             x-data="{ 
                loaded: false,
                content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
                init() {
                    setTimeout(() => this.loaded = true, 100);
                }
             }">
            <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 translate-y-8" x-transition:enter-end="opacity-100 translate-y-0">
                <span class="inline-block glass px-4 py-1.5 rounded-full text-accent text-sm font-bold tracking-wider mb-6 border border-accent/20"
                      x-text="content.hero_badge || 'PREMIUM CAR FINANCING'">
                    PREMIUM CAR FINANCING
                </span>
                <h1 class="text-5xl md:text-7xl font-extrabold mb-8 leading-tight"
                    x-html="content.hero_title ? content.hero_title.replace('Ambition', '<span class=\'text-gradient\'>Ambition</span>') : 'Drive Your <span class=\'text-gradient\'>Ambition</span> <br>With Ease.'">
                    Drive Your <span class="text-gradient">Ambition</span> <br>With Ease.
                </h1>
                <p class="text-gray-300 text-xl max-w-3xl mx-auto leading-relaxed mb-10"
                   x-text="content.hero_description || 'At Ultimate Auto Care, we believe that luxury and performance should be accessible. Our tailored financing solutions are designed to fit your unique lifestyle, whether you\'re eyeing a modern supercar or a restored classic.'">
                    At Ultimate Auto Care, we believe that luxury and performance should be accessible. Our tailored financing solutions are designed to fit your unique lifestyle, whether you're eyeing a modern supercar or a restored classic.
                </p>
                
                <!-- Creative Apply Button -->
                <div class="flex justify-center">
                    <a href="apply-financing.php" class="relative group">
                        <div class="absolute -inset-1 bg-gradient-to-r from-accent to-yellow-600 rounded-2xl blur opacity-25 group-hover:opacity-100 transition duration-1000 group-hover:duration-200"></div>
                        <button class="relative bg-accent hover:bg-accent-dark text-primary px-12 py-5 rounded-2xl font-black text-xl flex items-center space-x-4 transition-all transform hover:scale-105 shadow-2xl">
                            <span>APPLY FOR FINANCING</span>
                            <i class="fas fa-paper-plane animate-bounce-horizontal"></i>
                        </button>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Detailed Descriptions Section -->
    <section class="py-24 relative">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-20 items-center">
                <div class="space-y-12">
                    <div>
                        <h2 class="text-4xl font-bold mb-6 italic border-l-4 border-accent pl-6" x-text="content.process_title || 'Simplified Application Process'">Simplified Application Process</h2>
                        <p class="text-text-muted text-lg leading-relaxed" x-text="content.process_desc || 'We\'ve stripped away the complexity of traditional car loans. Our digital-first approach means you can get pre-approved in under 10 minutes from the comfort of your home. No mountains of paperwork, just straightforward financial support.'">
                            We've stripped away the complexity of traditional car loans. Our digital-first approach means you can get pre-approved in under 10 minutes from the comfort of your home. No mountains of paperwork, just straightforward financial support.
                        </p>
                    </div>

                    <div class="grid sm:grid-cols-2 gap-8">
                        <div class="glass p-8 rounded-3xl border border-white/5 hover:border-accent/20 transition-all">
                            <h3 class="text-xl font-bold mb-4 text-white">Versatile Loan Options</h3>
                            <p class="text-sm text-text-muted leading-relaxed">From fixed-rate traditional loans to flexible lease-to-own plans for our restored classics.</p>
                        </div>
                        <div class="glass p-8 rounded-3xl border border-white/5 hover:border-accent/20 transition-all">
                            <h3 class="text-xl font-bold mb-4 text-white">Zero Hidden Fees</h3>
                            <p class="text-sm text-text-muted leading-relaxed">Transparency is our core value. What you see is exactly what you pay, with no surprise costs.</p>
                        </div>
                    </div>
                </div>

                <div class="relative">
                    <div class="glass-card p-1 items-center rounded-[3rem] overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1552519507-da3b142c6e3d?q=80&w=2070" alt="Luxury Interior" class="rounded-[2.8rem] w-full h-[500px] object-cover opacity-80">
                        <div class="absolute inset-0 bg-gradient-to-t from-primary via-transparent to-transparent"></div>
                        <div class="absolute bottom-10 left-10 right-10">
                            <div class="glass p-6 rounded-2xl border border-accent/30">
                                <p class="text-accent font-bold mb-2">Did you know?</p>
                                <p class="text-sm">90% of our clients qualify for our "Eco-Incentive" rates on modern performance vehicles.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Additional Content Grid -->
    <section class="pb-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-5xl font-black mb-4">Why Choose <span class="text-accent">Our Plans?</span></h2>
                <div class="w-24 h-1 bg-accent mx-auto rounded-full"></div>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="glass-card p-10 rounded-3xl group">
                    <div class="text-accent text-4xl mb-6"><i class="fas fa-handshake"></i></div>
                    <h4 class="text-2xl font-bold mb-4">Personalized Terms</h4>
                    <p class="text-text-muted">We don't believe in one-size-fits-all. Every loan is customized based on your financial goals and vehicle choice.</p>
                </div>
                <div class="glass-card p-10 rounded-3xl group">
                    <div class="text-accent text-4xl mb-6"><i class="fas fa-shield-check"></i></div>
                    <h4 class="text-2xl font-bold mb-4">Secured & Encrypted</h4>
                    <p class="text-text-muted">Your financial data is protected by bank-level encryption. Safety is our priority throughout the application process.</p>
                </div>
                <div class="glass-card p-10 rounded-3xl group">
                    <div class="text-accent text-4xl mb-6"><i class="fas fa-history"></i></div>
                    <h4 class="text-2xl font-bold mb-4">Credit Evolution</h4>
                    <p class="text-text-muted">We work with all credit profiles. Our team specializes in helping enthusiasts build their credit while driving their passion.</p>
                </div>
            </div>
        </div>
    </section>
</main>

<style>
@keyframes bounce-horizontal {
    0%, 100% { transform: translateX(0); }
    50% { transform: translateX(5px); }
}
.animate-bounce-horizontal {
    animation: bounce-horizontal 1s infinite;
}
</style>

<?php include 'includes/footer.php'; ?>
