<?php 
include 'includes/header.php'; 
include 'config.php';

// Fetch all available cars
$query = "SELECT * FROM cars WHERE status = 'available' ORDER BY created_at DESC";
$stmt = $conn->query($query);
$cars = [];
while ($row = $stmt->fetch()) {
    // Sanitize image URL
    $row['image'] = sanitizeImageUrl($row['image']);

    // Ensure numeric values are numbers in JSON
    $row['price'] = (float)$row['price'];
    $row['year'] = (int)$row['year'];
    $row['is_featured'] = (bool)$row['is_featured'];
    $cars[] = $row;
}
?>

<main class="pt-52 pb-24" 
      x-data="{ 
        cars: <?php echo htmlspecialchars(json_encode($cars), ENT_QUOTES, 'UTF-8'); ?>,
        loading: false,
        init() {
            // No longer need to fetch via API
        }
      }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-16">
            <h1 class="text-5xl font-black mb-4">Elite <span class="text-gradient">Showroom</span></h1>
            <p class="text-text-muted text-lg max-w-2xl">Explore our curated collection of legendary classics and quality pre-owned vehicles.</p>
        </div>

        <!-- Inventory Grid -->
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <template x-for="car in cars" :key="car.id">
                <div class="glass-card rounded-[2rem] overflow-hidden group">
                    <div class="relative h-72 overflow-hidden">
                        <img :src="car.image" :alt="car.make + ' ' + car.model" 
                             @error="$event.target.src='https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?q=80&w=2000'"
                             class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                        <div class="absolute top-4 right-4 glass px-4 py-1.5 rounded-full text-xs font-black uppercase tracking-widest" :class="car.type === 'classic' ? 'text-accent' : 'text-green-400'">
                            <span x-text="car.type"></span>
                        </div>
                        <div class="absolute inset-0 car-overlay"></div>
                    </div>
                    
                    <div class="p-8">
                        <div class="flex justify-between items-start mb-6">
                            <div>
                                <h3 class="text-2xl font-bold" x-text="'Used ' + car.year + ' ' + car.make"></h3>
                                <p class="text-accent font-bold" x-text="car.model"></p>
                            </div>
                            <span class="text-2xl font-black" x-text="'$' + parseInt(car.price).toLocaleString()"></span>
                        </div>
                        
                        <p class="text-text-muted text-sm mb-8 leading-relaxed h-12 line-clamp-2" x-text="car.description"></p>
                        
                        <div class="flex items-center space-x-4 mb-8">
                            <div class="flex-1 glass py-3 px-4 rounded-xl text-center">
                                <i class="fas fa-gas-pump text-accent mb-1 block"></i>
                                <span class="text-[10px] font-bold uppercase text-text-muted">Petrol</span>
                            </div>
                            <div class="flex-1 glass py-3 px-4 rounded-xl text-center">
                                <i class="fas fa-cog text-accent mb-1 block"></i>
                                <span class="text-[10px] font-bold uppercase text-text-muted">Manual</span>
                            </div>
                            <div class="flex-1 glass py-3 px-4 rounded-xl text-center">
                                <i class="fas fa-road text-accent mb-1 block"></i>
                                <span class="text-[10px] font-bold uppercase text-text-muted">Verified</span>
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-2 gap-4">
                            <a :href="'car-detail.php?id=' + car.id" class="bg-white/5 hover:bg-white/10 text-center py-4 rounded-xl font-bold transition-all border border-white/10">
                                Details
                            </a>
                            <button @click="$dispatch('open-inquiry', car)" class="bg-accent hover:bg-accent-dark text-primary py-4 rounded-xl font-bold transition-all shadow-lg shadow-accent/20">
                                Inquire
                            </button>
                        </div>
                    </div>
                </div>
            </template>
        </div>

        <!-- Empty State -->
        <div x-show="cars.length === 0 && !loading" class="text-center py-32 glass rounded-[3rem] border-dashed">
            <i class="fas fa-car-rear text-6xl text-white/5 mb-6"></i>
            <h3 class="text-2xl font-bold mb-2">No matching vehicles found</h3>
            <p class="text-text-muted">Try adjusting your search or filters.</p>
            <button @click="search = ''; category = 'all'" class="mt-6 text-accent font-bold underline">Show All Inventory</button>
        </div>
    </div>

    <!-- Inquiry Modal (Alpine.js) -->
    <div x-data="{ open: false, selectedCar: null }" 
         @open-inquiry.window="open = true; selectedCar = $event.detail"
         x-show="open" 
         x-transition
         class="fixed inset-0 z-[100] flex items-center justify-center p-4">
        <div class="absolute inset-0 bg-black/80 backdrop-blur-sm" @click="open = false"></div>
        <div class="glass w-full max-w-lg rounded-[2.5rem] p-10 relative z-10 border border-white/10 overflow-hidden">
            <div class="absolute top-0 right-0 p-6">
                <button @click="open = false" class="text-text-muted hover:text-white"><i class="fas fa-times text-xl"></i></button>
            </div>
            
            <h2 class="text-3xl font-black mb-2">Inquiry For:</h2>
            <p class="text-accent text-xl font-bold mb-8" x-text="selectedCar ? selectedCar.year + ' ' + selectedCar.make + ' ' + selectedCar.model : ''"></p>
            
            <form class="space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <input type="text" placeholder="Your Name" class="bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent">
                    <input type="tel" placeholder="Phone Number" class="bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent">
                </div>
                <input type="email" placeholder="Email Address" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent">
                <textarea rows="4" placeholder="Your message or questions about this vehicle..." class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent"></textarea>
                
                <button type="submit" class="w-full bg-accent hover:bg-accent-dark text-primary py-4 rounded-xl font-bold text-lg transition-all shadow-xl shadow-accent/30">
                    Send Inquiry
                </button>
            </form>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>
