<?php
include 'config.php';

$action = $_GET['action'] ?? '';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    try {
        switch ($action) {
            case 'contact':
                $stmt = $conn->prepare("INSERT INTO contact_messages (name, email, subject, message, created_at, updated_at) VALUES (?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$input['name'], $input['email'], $input['subject'], $input['message']]);
                echo json_encode(['success' => true, 'message' => 'Message sent successfully!']);
                break;

            case 'booking':
                $stmt = $conn->prepare("INSERT INTO service_bookings (customer_name, customer_email, customer_phone, vehicle_make, service_type, preferred_date, notes, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $date = date('Y-m-d H:i:s', strtotime($input['preferred_date']));
                $stmt->execute([$input['customer_name'], $input['customer_email'], $input['customer_phone'], $input['vehicle_make'], $input['service_type'], $date, $input['notes']]);
                echo json_encode(['success' => true, 'message' => 'Booking request received!']);
                break;

            case 'newsletter':
                $stmt = $conn->prepare("INSERT INTO newsletter_subscribers (email, is_active, created_at, updated_at) VALUES (?, 1, NOW(), NOW()) ON DUPLICATE KEY UPDATE is_active = 1, updated_at = NOW()");
                $stmt->execute([$input['email']]);
                echo json_encode(['success' => true, 'message' => 'Subscribed successfully!']);
                break;

            case 'financing':
                $query = "INSERT INTO financing_applications (first_name, last_name, email, daytime_phone, address, city, state, zip_code, country, selected_vehicle, desired_loan_amount, additional_comments, consent_given, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";
                $stmt = $conn->prepare($query);
                $consent = 1;
                $stmt->execute([
                    $input['first_name'], $input['last_name'], $input['email'], $input['daytime_phone'], 
                    $input['address'], $input['city'], $input['state'], $input['zip_code'], 
                    $input['country'], $input['selected_vehicle'], $input['desired_loan_amount'], 
                    $input['additional_comments'], $consent
                ]);
                echo json_encode(['success' => true, 'message' => 'Application submitted successfully!']);
                break;

            default:
                echo json_encode(['success' => false, 'message' => 'Invalid action.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'POST request required.']);
}
?>
