<?php
include 'includes/header.php';
include 'config.php';

$id = $_GET['id'] ?? null;
$car = null;

if ($id) {
    $stmt = $conn->prepare("SELECT * FROM cars WHERE id = ? OR slug = ?");
    $stmt->execute([$id, $id]);
    $car = $stmt->fetch();
}

if ($car) {
    // Sanitize image URL
    $car['image'] = sanitizeImageUrl($car['image']);
}

if (!$car) {
    header('Location: cars.php');
    exit;
}

// Fetch recommendations
$rec_query = "SELECT * FROM cars WHERE id != ? AND status = 'available' LIMIT 8";
$rec_stmt = $conn->prepare($rec_query);
$rec_stmt->execute([$car['id']]);
$recommendations = $rec_stmt->fetchAll();

// Sanitize recommendations images
foreach ($recommendations as &$rec) {
    $rec['image'] = sanitizeImageUrl($rec['image']);
}
unset($rec);
?>

<main class="pt-32 pb-24" 
      x-data="{ 
        car: <?php echo htmlspecialchars(json_encode($car), ENT_QUOTES, 'UTF-8'); ?>,
        recommendations: <?php echo htmlspecialchars(json_encode($recommendations), ENT_QUOTES, 'UTF-8'); ?>,
        loading: false,
        monthly: <?php echo ceil($car['price'] / 60); ?>,
        init() {
            // Already initialized via PHP
        }
      }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8" x-show="!loading" x-cloak>
        
        <!-- Page Title -->
        <h1 class="text-4xl md:text-5xl font-black mb-12">
            Used <span x-text="car ? car.year + ' ' + car.make + ' ' + car.model : ''"></span>
        </h1>

        <div class="grid lg:grid-cols-3 gap-12 items-start">
            
            <!-- Left Column: Content -->
            <div class="lg:col-span-2 space-y-10">
                
                <!-- Main Car Image & Gallery -->
                <div class="space-y-6">
                    <div class="aspect-[16/9] rounded-[2.5rem] overflow-hidden border border-white/5 shadow-2xl relative group">
                        <img :src="car.image" 
                             @error="$event.target.src='https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?q=80&w=2000'"
                             class="w-full h-full object-cover">
                        <div class="absolute bottom-6 right-6 flex space-x-3">
                            <span class="glass px-4 py-2 rounded-xl text-xs font-bold flex items-center">
                                <i class="fas fa-camera mr-2"></i> 24 Photos
                            </span>
                            <span class="glass px-4 py-2 rounded-xl text-xs font-bold flex items-center">
                                <i class="fas fa-video mr-2"></i> Virtual Tour
                            </span>
                        </div>
                    </div>
                    <div class="grid grid-cols-4 gap-4">
                        <?php for($i=0; $i<4; $i++): ?>
                        <div class="aspect-video rounded-2xl overflow-hidden glass border border-white/10 cursor-pointer hover:border-accent transition-all">
                            <img :src="car.image" 
                                 @error="$event.target.src='https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?q=80&w=2000'"
                                 class="w-full h-full object-cover opacity-60 hover:opacity-100 transition-all">
                        </div>
                        <?php endfor; ?>
                    </div>
                </div>

                <!-- Price & Highlights Card -->
                <div class="glass p-10 rounded-[2.5rem] border-white/5 shadow-xl">
                    <div class="flex flex-wrap justify-between items-start gap-6 mb-8">
                        <div>
                            <div class="flex items-center space-x-3 mb-2 text-3xl md:text-5xl font-black">
                                <span x-text="'$' + parseInt(car.price).toLocaleString()"></span>
                                <span class="text-accent text-sm font-bold flex items-center">
                                    <i class="fas fa-arrow-down mr-1"></i> $1,250
                                </span>
                            </div>
                            <div class="flex items-center space-x-2 text-text-muted font-bold">
                                <span>$<span x-text="monthly"></span> Est. monthly payment</span>
                                <i class="fas fa-calculator text-xs"></i>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-2xl font-black text-white" x-text="car.mileage"></p>
                        </div>
                    </div>

                    <div class="flex flex-wrap gap-3">
                        <span class="bg-accent/10 border border-accent/20 text-accent px-4 py-1.5 rounded-full text-[10px] font-black uppercase tracking-widest flex items-center">
                            <i class="fas fa-arrow-up mr-2"></i> Great Deal
                        </span>
                        <span class="bg-white/5 border border-white/10 text-text-muted px-4 py-1.5 rounded-full text-[10px] font-black uppercase tracking-widest">
                            Price Drop
                        </span>
                        <span class="bg-white/5 border border-white/10 text-text-muted px-4 py-1.5 rounded-full text-[10px] font-black uppercase tracking-widest flex items-center">
                            <i class="fas fa-flag-usa mr-2"></i> American-Made Index
                        </span>
                    </div>
                </div>

                <!-- Market Value Section -->
                <div class="glass p-10 rounded-[2.5rem] border-white/5 shadow-xl">
                    <h3 class="text-2xl font-black mb-4">This vehicle is a <span class="text-accent">great deal</span></h3>
                    <p class="text-text-muted mb-8 leading-relaxed">This vehicle is below the current average market range for its condition and mileage.</p>
                    
                    <div class="relative py-12">
                        <!-- Simplified Market Range Chart -->
                        <div class="h-2 w-full bg-white/5 rounded-full relative">
                            <div class="absolute h-full bg-accent rounded-full left-[20%] right-[40%]"></div>
                            <!-- Current Price Marker -->
                            <div class="absolute top-1/2 -translate-y-1/2 left-[18%]">
                                <div class="w-6 h-6 bg-accent border-4 border-primary rounded-full shadow-lg shadow-accent/40 relative">
                                    <div class="absolute bottom-8 left-1/2 -translate-x-1/2 whitespace-nowrap bg-accent text-primary px-3 py-1 rounded-lg text-xs font-black">
                                        <span x-text="'$' + parseInt(car.price).toLocaleString()"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex justify-between mt-6 text-xs font-black tracking-widest text-text-muted uppercase">
                            <span x-text="'$' + parseInt(car.market_avg_price * 0.8 || car.price * 0.8).toLocaleString()"></span>
                            <span x-text="'$' + parseInt(car.market_avg_price || car.price * 1.05).toLocaleString() + ' Avg'"></span>
                            <span x-text="'$' + parseInt(car.market_avg_price * 1.2 || car.price * 1.2).toLocaleString()"></span>
                        </div>
                    </div>

                    <div class="pt-8 border-t border-white/5 flex justify-between items-center cursor-pointer group">
                        <div class="flex items-center">
                            <i class="fas fa-chart-line text-accent mr-3"></i>
                            <span class="font-bold">Price history</span>
                        </div>
                        <i class="fas fa-chevron-down text-text-muted group-hover:text-white transition-colors"></i>
                    </div>
                </div>

                <!-- Features & Specs -->
                <div class="glass p-10 rounded-[2.5rem] border-white/5 shadow-xl">
                    <h3 class="text-2xl font-black mb-2">Features & specs</h3>
                    <p class="text-text-muted text-xs font-bold mb-10 uppercase tracking-widest">
                        VIN: <span x-text="car.vin || 'N/A'"></span> | Stock #: <span x-text="car.stock_number || 'N/A'"></span>
                    </p>

                    <div class="grid md:grid-cols-2 gap-y-8 gap-x-12">
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-accent">
                                <i class="fas fa-paint-brush"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1">Exterior</p>
                                <p class="font-bold text-white" x-text="car.ext_color || 'N/A'"></p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-accent">
                                <i class="fas fa-dharmachakra"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1">Drivetrain</p>
                                <p class="font-bold text-white" x-text="car.drive_type || 'N/A'"></p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-accent">
                                <i class="fas fa-gas-pump"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1">Fuel type</p>
                                <p class="font-bold text-white" x-text="car.fuel_type || 'N/A'"></p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-accent">
                                <i class="fas fa-cogs"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1">Transmission</p>
                                <p class="font-bold text-white" x-text="car.transmission || 'N/A'"></p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-accent">
                                <i class="fas fa-engine"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1">Engine</p>
                                <p class="font-bold text-white" x-text="car.engine || 'N/A'"></p>
                            </div>
                        </div>
                        <div class="flex items-center space-x-4">
                            <div class="w-10 h-10 rounded-xl bg-accent/20 flex items-center justify-center text-accent">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <div>
                                <p class="text-[10px] text-text-muted uppercase font-black tracking-widest leading-none mb-1 text-accent">Safety</p>
                                <p class="font-bold text-white">No accidents reported</p>
                            </div>
                        </div>
                    </div>

                    <button class="mt-12 w-full py-4 rounded-2xl border border-white/10 font-bold hover:bg-white/5 transition-all flex items-center justify-center group">
                        See all features & specs <i class="fas fa-arrow-right ml-3 group-hover:translate-x-2 transition-transform"></i>
                    </button>
                </div>

                <!-- Seller's Notes -->
                <div class="glass p-10 rounded-[2.5rem] border-white/5 shadow-xl">
                    <h3 class="text-2xl font-black mb-6">Seller's notes</h3>
                    <p class="text-text-muted leading-relaxed mb-8">
                        <span x-text="car.description"></span> Additionally, this vehicle has passed a comprehensive 150-point inspection and comes with a 3-month/3,000-mile limited warranty for your peace of mind.
                    </p>
                    <div class="flex space-x-6">
                        <button class="text-accent font-black text-sm uppercase tracking-widest hover:underline flex items-center">
                            Show more seller's notes <i class="fas fa-chevron-down ml-2 text-xs"></i>
                        </button>
                        <button class="text-white/60 font-black text-sm uppercase tracking-widest hover:text-white transition-colors flex items-center">
                            Visit dealership website <i class="fas fa-external-link-alt ml-2 text-xs"></i>
                        </button>
                    </div>
                </div>

                <!-- History Report -->
                <div class="glass p-10 rounded-[2.5rem] border-white/5 shadow-xl">
                    <h3 class="text-2xl font-black mb-10">Vehicle history report</h3>
                    <div class="bg-white rounded-xl p-4 w-fit mb-10">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/cb/Experian_logo.svg/1024px-Experian_logo.svg.png" class="h-6 object-contain" alt="Experian">
                    </div>

                    <div class="grid md:grid-cols-2 gap-6 mb-10">
                        <div class="flex items-center space-x-4">
                            <i class="fas fa-check text-green-500"></i>
                            <span class="font-bold text-sm">Clean title</span>
                        </div>
                        <div class="flex items-center space-x-4">
                            <i class="fas fa-check text-green-500"></i>
                            <span class="font-bold text-sm">Personal use only</span>
                        </div>
                        <div class="flex items-center space-x-4">
                            <i class="fas fa-check text-green-500"></i>
                            <span class="font-bold text-sm">No accidents reported</span>
                        </div>
                        <div class="flex items-center space-x-4">
                            <i class="fas fa-check text-green-500"></i>
                            <span class="font-bold text-sm">No open recalls reported</span>
                        </div>
                        <div class="flex items-center space-x-4">
                            <i class="fas fa-info-circle text-accent"></i>
                            <span class="font-bold text-sm">Single owner vehicle</span>
                        </div>
                    </div>

                    <a href="#" class="inline-flex items-center text-accent font-black text-sm uppercase tracking-widest hover:underline">
                        Get the full report <i class="fas fa-arrow-right ml-3"></i>
                    </a>
                </div>

            </div>

            <!-- Right Column: Form Sidebar -->
            <div class="lg:sticky lg:top-32 space-y-8">
                
                <div class="glass p-8 rounded-[2.5rem] border border-accent/20 shadow-2xl relative overflow-hidden">
                    <!-- Subtle glow -->
                    <div class="absolute -top-20 -right-20 w-40 h-40 bg-accent/20 rounded-full blur-3xl opacity-50"></div>
                    
                    <div class="relative z-10">
                        <div class="flex justify-between items-start mb-6">
                            <h3 class="text-2xl font-black text-white">Contact seller</h3>
                            <span class="text-accent font-black text-lg">(954) 485-4688</span>
                        </div>
                        
                        <div class="flex items-center space-x-4 mb-8">
                            <div class="w-12 h-12 bg-white/5 border border-white/10 rounded-xl flex items-center justify-center text-accent text-xl font-black">
                                <i class="fas fa-warehouse"></i>
                            </div>
                            <div>
                                <p class="font-bold text-white m-0 leading-none mb-1 text-lg" x-text="car.seller_name || 'Ultimate Auto Care'"></p>
                                <div class="flex items-center space-x-2">
                                    <span class="text-xs bg-accent text-primary px-1.5 py-0.5 rounded font-black">4.9</span>
                                    <span class="text-xs text-text-muted font-bold">Lauderdale, FL</span>
                                </div>
                            </div>
                        </div>

                        <form class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <input type="text" placeholder="First name" class="bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent text-sm font-bold text-white placeholder-text-muted/50">
                                <input type="text" placeholder="Last name" class="bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent text-sm font-bold text-white placeholder-text-muted/50">
                            </div>
                            <input type="email" placeholder="Email" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent text-sm font-bold text-white placeholder-text-muted/50">
                            <input type="tel" placeholder="Phone (optional)" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent text-sm font-bold text-white placeholder-text-muted/50">
                            <textarea rows="4" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 focus:outline-none focus:border-accent text-sm font-bold text-white placeholder-text-muted/50 h-32" 
                                      x-text="'I\'d like to know if the Used ' + car.year + ' ' + car.make + ' ' + car.model + ' you have listed for $' + parseInt(car.price).toLocaleString() + ' is still available.'"></textarea>
                            
                            <button type="button" class="w-full bg-accent hover:bg-accent-dark text-primary py-4 rounded-2xl font-black text-lg transition-all shadow-xl shadow-accent/20 transform hover:-translate-y-1 active:scale-95">
                                Apply For Financing
                            </button>
                            <button type="button" class="w-full bg-white/5 hover:bg-white/10 text-white py-4 rounded-2xl font-black text-lg border border-white/10 transition-all transform hover:-translate-y-1 active:scale-95">
                                Scheduled Test Drive
                            </button>
                        </form>
                        
                        <p class="text-[9px] text-text-muted mt-6 leading-relaxed">
                            By clicking here, you authorize Ultimate Auto Care and its partners to contact you by text/calls which may include marketing and be by autodialer. Consent is not required to purchase goods/services.
                        </p>
                    </div>
                </div>

                <!-- Instant Offer Minor Card -->
                <div class="glass p-8 rounded-[2.5rem] border border-white/5">
                    <h4 class="text-xl font-black mb-4">Get your instant offer!</h4>
                    <p class="text-text-muted text-sm leading-relaxed mb-6">Sell or trade in your vehicle with instant offers from local dealers.</p>
                    <button class="w-full py-4 rounded-xl border border-accent text-accent font-black text-sm uppercase tracking-widest hover:bg-accent hover:text-primary transition-all">
                        Get Started
                    </button>
                </div>

            </div>

        </div>

        <!-- Recommendations (Keeping existing section) -->
        <div class="mt-32" x-data="{ 
            recommendations: <?php echo htmlspecialchars(json_encode(array_merge($recommendations, $recommendations)), ENT_QUOTES, 'UTF-8'); ?>,
            scrollPos: 0,
            isHovered: false,
            init() {
                this.$nextTick(() => {
                    this.startAutomation();
                });
            },
            startAutomation() {
                const container = this.$refs.scrollContainer;
                if (!container) return;

                const step = () => {
                    if (!this.isHovered) {
                        this.scrollPos += 0.5;
                        container.scrollLeft = this.scrollPos;

                        if (this.scrollPos >= container.scrollWidth / 2) {
                            this.scrollPos = 0;
                            container.scrollLeft = 0;
                        }
                    } else {
                        this.scrollPos = container.scrollLeft;
                    }
                    requestAnimationFrame(step);
                };
                requestAnimationFrame(step);
            }
        }">
            <h2 class="text-4xl font-black mb-12">Other <span class="text-accent">Recommendations</span></h2>
            <div class="flex overflow-x-auto gap-8 pb-12 scrollbar-hide" 
                 x-ref="scrollContainer"
                 @mouseenter="isHovered = true" 
                 @mouseleave="isHovered = false">
                <template x-for="(recCar, index) in recommendations" :key="index">
                    <div class="min-w-[350px] md:min-w-[400px]">
                        <div class="glass-card rounded-[2.5rem] overflow-hidden group/card h-full flex flex-col">
                            <div class="relative h-56 overflow-hidden">
                                <img :src="recCar.image" 
                                     @error="$event.target.src='https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?q=80&w=2000'"
                                     class="w-full h-full object-cover transform group-hover/card:scale-110 transition-transform duration-700">
                                <div class="absolute inset-0 car-overlay"></div>
                            </div>
                            <div class="p-8 flex flex-col flex-grow">
                                <div class="flex justify-between items-start mb-4">
                                    <div>
                                        <h3 class="text-xl font-bold" x-text="recCar.year + ' ' + recCar.make"></h3>
                                        <p class="text-accent font-bold text-sm" x-text="recCar.model"></p>
                                    </div>
                                    <span class="text-xl font-black" x-text="'$' + parseInt(recCar.price).toLocaleString()"></span>
                                </div>
                                <div class="mt-auto">
                                    <a :href="'car-detail.php?id=' + recCar.id" class="block text-center bg-white/5 hover:bg-accent hover:text-primary py-4 rounded-xl font-bold transition-all border border-white/10">
                                        View Details
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>

    </div>
</main>

<style>
.scrollbar-hide::-webkit-scrollbar { display: none; }
.scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
</style>

<?php include 'includes/footer.php'; ?>
