<?php
// Database configuration
$db_host = "localhost";
$db_name = "u784207861_subhajit_dev";
$db_user = "u784207861_subhajit_user";
$db_pass = "I/q4&!iD";

// Create connection
try {
    $conn_str = "mysql:host=$db_host;dbname=$db_name;charset=utf8mb4";
    $pdo = new PDO($conn_str, $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    
    // For compatibility with scripts using $conn
    $conn = $pdo; 
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

/**
 * Helper function to get page content
 */
function getPageContent($conn, $pageName) {
    $content = [];
    try {
        $stmt = $conn->prepare("SELECT section_key, content_value FROM page_contents WHERE page_name = ?");
        $stmt->execute([$pageName]);
        while ($row = $stmt->fetch()) {
            $content[$row['section_key']] = $row['content_value'];
        }
    } catch (PDOException $e) {
        // Silent fail or log
    }
    return $content;
}

/**
 * Sanitize image URLs to be relative to the frontend storage
 */
function sanitizeImageUrl($url) {
    if (!$url) return '';
    
    // Normalize slashes to forward slashes first
    $url = str_replace('\\', '/', $url);
    
    // If it's already an external URL, leave it alone
    if (strpos($url, 'http') === 0 && strpos($url, 'localhost') === false && strpos($url, '127.0.0.1') === false) {
        return $url;
    }
    
    // Extract the filename from the end of the path
    $parts = explode('/', $url);
    $filename = end($parts);
    
    // If we have a valid-looking filename and it was in a cars directory,
    // map it to our local storage/cars/ directory
    if ($filename && (strpos($url, '/cars/') !== false || strpos($url, 'cars/') === 0)) {
        return 'storage/cars/' . $filename;
    }
    
    // Fallback: if it contains /storage/, strip everything before it
    if (strpos($url, '/storage/') !== false) {
        $parts = explode('/storage/', $url);
        return 'storage/' . end($parts);
    }
    
    return $url;
}
?>
