<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate Auto Care | Premium Car Repair & Restored Classics</title>
    <meta name="description" content="Expert car repair services and premium vintage cars for sale. From diagnostics to restoration, Ultimate Auto Care is your trusted automotive partner.">
    
    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0f172a',
                        secondary: '#1e293b',
                        accent: '#facc15',
                        'accent-dark': '#eab308',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif'],
                        display: ['Outfit', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/index.css">
</head>
<body class="bg-primary text-white">

    <!-- Navigation -->
    <nav class="fixed w-full z-50 nav-blur" x-data="{ mobileMenuOpen: false, scrolled: false }" 
         @scroll.window="scrolled = (window.pageYOffset > 20)">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <!-- Logo -->
                <a href="index.php" class="flex items-center space-x-2 group">
                    <div class="w-10 h-10 bg-accent rounded-lg flex items-center justify-center transform group-hover:rotate-12 transition-transform">
                        <i class="fas fa-car-side text-primary text-xl"></i>
                    </div>
                    <span class="text-2xl font-display font-bold tracking-tight">Ultimate<span class="text-accent">AutoCare</span></span>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="index.php" class="text-sm font-medium hover:text-accent transition-colors">Home</a>
                    <a href="services.php" class="text-sm font-medium hover:text-accent transition-colors">Services</a>
                    <a href="cars.php" class="text-sm font-medium hover:text-accent transition-colors">Shop Cars</a>
                    
                    <!-- Financing Dropdown -->
                    <div class="relative group" x-data="{ open: false }" @mouseenter="open = true" @mouseleave="open = false">
                        <button class="flex items-center space-x-1 text-sm font-medium hover:text-accent transition-colors py-2">
                            <span>FINANCING</span>
                            <i class="fas fa-chevron-down text-[10px] transition-transform duration-300" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" 
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 translate-y-2"
                             x-transition:enter-end="opacity-100 translate-y-0"
                             x-transition:leave="transition ease-in duration-150"
                             x-transition:leave-start="opacity-100 translate-y-0"
                             x-transition:leave-end="opacity-0 translate-y-2"
                             class="absolute left-0 mt-0 w-64 glass rounded-2xl shadow-2xl border border-white/10 p-2 z-50 overflow-hidden"
                             x-cloak>
                            <a href="car-financing.php" class="flex items-center space-x-3 p-3 rounded-xl hover:bg-accent hover:text-primary transition-all group/item">
                                <div class="w-10 h-10 bg-white/5 rounded-lg flex items-center justify-center group-hover/item:bg-primary/20">
                                    <i class="fas fa-car-side"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold">Car sale Financing</p>
                                    <p class="text-[10px] opacity-70">Flexible plans for your next car</p>
                                </div>
                            </a>
                            <a href="repair-financing.php" class="flex items-center space-x-3 p-3 rounded-xl hover:bg-accent hover:text-primary transition-all group/item">
                                <div class="w-10 h-10 bg-white/5 rounded-lg flex items-center justify-center group-hover/item:bg-primary/20">
                                    <i class="fas fa-tools"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold">Automotive Repair Financing</p>
                                    <p class="text-[10px] opacity-70">Easy payments for major repairs</p>
                                </div>
                            </a>
                        </div>
                    </div>

                    <a href="about.php" class="text-sm font-medium hover:text-accent transition-colors">About</a>
                    <a href="contact.php" class="text-sm font-medium hover:text-accent transition-colors">Contact</a>
                    <a href="contact.php" class="bg-accent hover:bg-accent-dark text-primary px-6 py-2.5 rounded-full text-sm font-bold transition-all transform hover:scale-105">
                        Book Service
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" class="text-gray-300 hover:text-white">
                        <i class="fas" :class="mobileMenuOpen ? 'fa-times' : 'fa-bars'"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div x-show="mobileMenuOpen" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 -translate-y-4"
             x-transition:enter-end="opacity-100 translate-y-0"
             class="md:hidden bg-secondary border-b border-white/5 py-4 px-4 space-y-4">
            <a href="index.php" class="block text-lg font-medium">Home</a>
            <a href="services.php" class="block text-lg font-medium">Services</a>
            <a href="cars.php" class="block text-lg font-medium">Shop Cars</a>
            
            <div x-data="{ open: false }">
                <button @click="open = !open" class="flex justify-between items-center w-full text-lg font-medium py-2">
                    <span>FINANCING</span>
                    <i class="fas" :class="open ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                </button>
                <div x-show="open" class="pl-4 space-y-3 mt-2 mb-4 border-l border-accent/20">
                    <a href="car-financing.php" class="block text-base text-gray-400 hover:text-accent">Car sale Financing</a>
                    <a href="repair-financing.php" class="block text-base text-gray-400 hover:text-accent">Automotive Repair Financing</a>
                </div>
            </div>

            <a href="about.php" class="block text-lg font-medium">About</a>
            <a href="contact.php" class="block text-lg font-medium text-accent">Book Now</a>
        </div>
    </nav>
